/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.cr.taskest;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.cr.TaskEstDefinition;
import org.eclipse.osee.ats.api.workflow.cr.TaskEstUtil;
import org.eclipse.osee.ats.core.workflow.cr.CreateSiblingOffTaskEstOperation;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.ActionableItemCheckboxStateDialog;
import org.eclipse.osee.ats.ide.workflow.cr.taskest.XTaskEstWidget;
import org.eclipse.osee.ats.ide.workflow.cr.taskest.XTaskEstXViewerFactory;
import org.eclipse.osee.ats.ide.workflow.task.TaskXViewer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.IDirtiableEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public abstract class XTaskEstViewer
extends TaskXViewer {
    protected final IAtsTeamWorkflow crTeamWf;
    protected final AtsApi atsApi = AtsApiService.get();

    public XTaskEstViewer(Composite parent, int style, IXViewerFactory xViewerFactory, IDirtiableEditor editor, IAtsTeamWorkflow teamWf) {
        super(parent, style, xViewerFactory, editor, teamWf);
        this.crTeamWf = teamWf;
    }

    public boolean handleLeftClickInIconArea(TreeColumn treeColumn, TreeItem treeItem) {
        XViewerColumn xViewerColumn = (XViewerColumn)treeColumn.getData();
        if (xViewerColumn.getName().equals(XTaskEstXViewerFactory.Check_Col.getName())) {
            TaskEstDefinition ted;
            List<TaskEstDefinition> selected = this.getSelected();
            if (selected.isEmpty()) {
                return false;
            }
            ted.setChecked(!(ted = selected.iterator().next()).isChecked());
            this.refresh(ted);
        } else if (xViewerColumn.getName().equals(XTaskEstXViewerFactory.Related_Wf_Col.getName()) && treeItem.getData() instanceof IAtsTask) {
            IAtsTask task = (IAtsTask)treeItem.getData();
            if (task.isCancelled()) {
                return false;
            }
            IAtsTeamWorkflow teamWf = TaskEstUtil.getWorkflow((IAtsTeamWorkflow)this.crTeamWf, (IAtsTask)task, (AtsApi)this.atsApi);
            if (teamWf != null) {
                WorkflowEditor.edit((IAtsWorkItem)teamWf);
            } else {
                String ptsStr = this.atsApi.getAgileService().getPointsStr((IAtsWorkItem)task);
                if (!Strings.isValid((String)ptsStr)) {
                    AWorkbench.popupf((String)"No estimated points for task %s\n", (Object[])new Object[]{task.toStringWithAtsId()});
                    return false;
                }
                if (!Strings.isNumeric((String)ptsStr)) {
                    AWorkbench.popupf((String)"Estimated points non-numeric for task %s\n", (Object[])new Object[]{task.toStringWithAtsId()});
                    return false;
                }
                Double pts = Double.valueOf(ptsStr);
                if (pts > 0.0) {
                    if (this.atsApi.getAttributeResolver().getAttributeCount((IAtsWorkItem)task, (AttributeTypeToken)AtsAttributeTypes.TleReviewedBy) == 0) {
                        AWorkbench.popupf((String)"TLE Reviewed must be set for task %s\n", (Object[])new Object[]{task.toStringWithAtsId()});
                        return false;
                    }
                    return this.createWorkflow(task);
                }
                AWorkbench.popupf((String)"Estimated points must be > 0 for task %s\n", (Object[])new Object[]{task.toStringWithAtsId()});
                return false;
            }
        }
        return true;
    }

    protected abstract XTaskEstWidget getXTaskEstWidget();

    private boolean createWorkflow(IAtsTask task) {
        ArtifactToken art;
        XTaskEstWidget estWidget = this.getXTaskEstWidget();
        estWidget.setArtifact((Artifact)this.crTeamWf.getStoreObject());
        TaskEstDefinition tedMatch = null;
        for (TaskEstDefinition ted : estWidget.getTaskEstDefs()) {
            if (!task.hasTag(ted.getIdString())) continue;
            tedMatch = ted;
            break;
        }
        IAtsActionableItem useAi = IAtsActionableItem.SENTINEL;
        if (tedMatch != null && (art = tedMatch.getActionableItem()) != null && art.isValid()) {
            useAi = this.atsApi.getActionableItemService().getActionableItemById((ArtifactId)art);
        }
        if (useAi.isInvalid()) {
            ActionableItemCheckboxStateDialog dialog = new ActionableItemCheckboxStateDialog("Create Team Workflow off Task Estimate", "Select a single Actionable Item for new Team Workflow", this.atsApi.getActionableItemService().getTopLevelActionableItems(Active.Active));
            if (dialog.open() == 0) {
                useAi = dialog.getSelectedActionableItems().iterator().next();
            } else {
                return false;
            }
        }
        IAtsTeamDefinition teamDef = this.atsApi.getActionableItemService().getTeamDefinitionInherited(useAi);
        List assignees = TaskEstUtil.getAssignees((TaskEstDefinition)tedMatch, (AtsApi)this.atsApi);
        if (assignees.isEmpty()) {
            assignees.add(AtsCoreUsers.UNASSIGNED_USER);
        }
        IAtsAction action = this.crTeamWf.getParentAction();
        XResultData rd = new XResultData();
        IAtsChangeSet changes = this.atsApi.createChangeSet("Create Task Est Workflow");
        IAtsTeamWorkflow newTeamWf = CreateSiblingOffTaskEstOperation.createTaskEstSiblingWorkflow((XResultData)rd, (IAtsChangeSet)changes, (Date)new Date(), (IAtsTask)task, (IAtsActionableItem)useAi, (IAtsTeamDefinition)teamDef, (List)assignees, (IAtsAction)action, (AtsApi)this.atsApi);
        this.workflowCreating(newTeamWf, changes);
        changes.execute();
        if (rd.isErrors()) {
            XResultDataUI.report((XResultData)rd, (String)"Create Task Est Workflow");
            return false;
        }
        return true;
    }

    protected void workflowCreating(IAtsTeamWorkflow teamWf, IAtsChangeSet changes) {
    }

    @Override
    protected boolean isAddTaskEnabled() {
        return false;
    }

    public List<TaskEstDefinition> getSelected() {
        ArrayList<TaskEstDefinition> teds = new ArrayList<TaskEstDefinition>();
        TreeItem[] items = this.getTree().getSelection();
        if (items.length > 0) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (item.getData() instanceof TaskEstDefinition) {
                    teds.add((TaskEstDefinition)item.getData());
                }
                ++n2;
            }
        }
        return teds;
    }
}

