/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.IAtsColumnId;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.core.column.AtsColumnId;
import org.eclipse.osee.ats.ide.column.ev.WorkPackageColumnUI;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.GenericXWidget;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class XWorkPackageWidget
extends GenericXWidget
implements ArtifactWidget {
    public static final String WIDGET_ID = XWorkPackageWidget.class.getSimpleName();
    protected static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private Composite composite;
    private AbstractWorkflowArtifact workflow;
    private Text textWidget;
    private Button button;

    public XWorkPackageWidget() {
        super("Work Package");
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        this.composite = new Composite(parent, 0);
        GridLayout gL = new GridLayout(3, false);
        gL.marginWidth = 0;
        gL.marginHeight = 0;
        this.composite.setLayout((Layout)gL);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.isDisplayLabel()) {
            this.labelWidget = new Label(this.composite, 0);
            this.labelWidget.setText("Work Package:");
        }
        this.createButton(this.composite);
        this.textWidget = new Text(this.composite, 2056);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.textWidget.setLayoutData((Object)data);
        this.textWidget.setBackground(Displays.getSystemColor((int)1));
        this.textWidget.setDoubleClickEnabled(false);
        this.textWidget.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                XWorkPackageWidget.this.handlePromptChange();
            }
        });
        this.refreshText();
    }

    private void createButton(Composite parent) {
        this.button = new Button(parent, 8);
        this.button.setText("Select");
        this.button.setLayoutData((Object)new GridData());
        this.button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                XWorkPackageWidget.this.handlePromptChange();
            }
        });
    }

    private void handlePromptChange() {
        if (this.workflow.isInWork()) {
            WorkPackageColumnUI.promptChangeActivityId(this.workflow, true);
        } else {
            AWorkbench.popup((String)"Work Package can not be set on completed/cancelled workflow");
        }
        this.refreshText();
    }

    public void dispose() {
        if (this.composite != null) {
            this.composite.dispose();
        }
    }

    public Control getControl() {
        return this.textWidget;
    }

    public Control getButtonControl() {
        return this.button;
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setEnabled(editable);
        }
        if (this.getButtonControl() != null && !this.getButtonControl().isDisposed()) {
            this.getButtonControl().setEnabled(editable);
        }
    }

    public String getReportData() {
        String result = "";
        try {
            result = AtsApiService.get().getColumnService().getColumn((IAtsColumnId)AtsColumnId.ActivityId).getColumnText((IAtsObject)this.workflow);
        }
        catch (Exception ex) {
            result = "Error resolving work package (see log for details)";
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)result, (Throwable)ex);
        }
        return result;
    }

    public IStatus isValid() {
        if (this.isRequiredEntry() && this.isEmpty()) {
            return new Status(4, "org.eclipse.osee.ats.ide", "Must select a Work Package");
        }
        return Status.OK_STATUS;
    }

    public boolean isEmpty() {
        return AtsApiService.get().getEarnedValueService().getWorkPackage((IAtsWorkItem)this.workflow) == null;
    }

    public void setFocus() {
        this.textWidget.setFocus();
    }

    public void setDisplayLabel(final String displayLabel) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                XWorkPackageWidget.super.setDisplayLabel(displayLabel);
                XWorkPackageWidget.this.getLabelWidget().setText(displayLabel);
            }
        });
    }

    public void setArtifact(Artifact artifact) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) {
            this.workflow = (AbstractWorkflowArtifact)artifact;
        }
    }

    public Artifact getArtifact() {
        return this.workflow;
    }

    public void saveToArtifact() {
    }

    public void revert() {
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    private void refreshText() {
        String workPackageStr = this.getReportData();
        if (Strings.isValid((String)workPackageStr)) {
            this.textWidget.setText(workPackageStr);
        } else {
            this.textWidget.setText(" -- Select A Work Package -- ");
        }
    }

    public void refresh() {
        super.refresh();
        this.refreshText();
    }
}

