/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class FavoritesManager {
    private final Collection<AbstractWorkflowArtifact> awas;

    public FavoritesManager(AbstractWorkflowArtifact sma) {
        this(Arrays.asList(sma));
    }

    public FavoritesManager(Collection<AbstractWorkflowArtifact> awas) {
        this.awas = awas;
    }

    public void toggleFavorite(boolean prompt) {
        try {
            if (FavoritesManager.amIFavorite(this.awas.iterator().next())) {
                boolean result = true;
                if (prompt) {
                    result = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Remove Favorite", (String)"Are You sure you wish to remove this as Favorite?");
                }
                if (result) {
                    SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)AtsApiService.get().getAtsBranch(), (String)"Toggle Favorites");
                    for (AbstractWorkflowArtifact awa : this.awas) {
                        FavoritesManager.removeFavorite(awa, AtsApiService.get().getUserService().getCurrentUser(), transaction);
                    }
                    transaction.execute();
                }
            } else {
                boolean result = true;
                if (prompt) {
                    result = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Favorite", (String)"Are you sure you wish add this as a Favorite?");
                }
                if (result) {
                    SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)AtsApiService.get().getAtsBranch(), (String)"Toggle Favorites");
                    for (AbstractWorkflowArtifact awa : this.awas) {
                        FavoritesManager.addFavorite(awa, AtsApiService.get().getUserService().getCurrentUser(), transaction);
                    }
                    transaction.execute();
                }
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public static boolean amIFavorite(AbstractWorkflowArtifact workflow) {
        try {
            return FavoritesManager.isFavorite(workflow, AtsApiService.get().getUserService().getCurrentUser());
        }
        catch (OseeCoreException oseeCoreException) {
            return false;
        }
    }

    public static void addFavorite(AbstractWorkflowArtifact workflow, AtsUser user, SkynetTransaction transaction) {
        if (!workflow.getRelatedArtifactsUnSorted(AtsRelationTypes.FavoriteUser_User).contains(user.getStoreObject())) {
            workflow.addRelation(AtsRelationTypes.FavoriteUser_User, (Artifact)AtsApiService.get().getQueryService().getArtifact(user.getArtifactId()));
            workflow.persist(transaction);
        }
    }

    public static void removeFavorite(AbstractWorkflowArtifact workflow, AtsUser user, SkynetTransaction transaction) {
        workflow.deleteRelation(AtsRelationTypes.FavoriteUser_User, (Artifact)AtsApiService.get().getQueryService().getArtifact(user.getArtifactId()));
        workflow.persist(transaction);
    }

    public static boolean isFavorite(AbstractWorkflowArtifact workflow, AtsUser user) {
        return workflow.getRelatedArtifactsUnSorted(AtsRelationTypes.FavoriteUser_User).contains(user.getStoreObject());
    }
}

