/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search.widget;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.search.widget.AbstractXComboViewerSearchWidget;
import org.eclipse.osee.ats.ide.world.WorldEditorParameterSearchItem;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.ui.skynet.widgets.XComboViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;

public class ProgramSearchWidget
extends AbstractXComboViewerSearchWidget<IAtsProgram> {
    public static final String PROGRAM = "Program";

    public ProgramSearchWidget(WorldEditorParameterSearchItem searchItem) {
        super(PROGRAM, searchItem);
    }

    @Override
    public void set(AtsSearchData data) {
        if (this.getWidget() != null) {
            this.setup((XWidget)this.getWidget());
            ArtifactId programId = ArtifactId.valueOf((Long)data.getProgramId());
            XComboViewer combo = this.getWidget();
            if (programId.isValid()) {
                IAtsProgram program = AtsApiService.get().getProgramService().getProgramById(programId);
                combo.setSelected(Arrays.asList(program));
            }
        }
    }

    @Override
    public Collection<IAtsProgram> getInput() {
        return Collections.castAll((Collection)AtsApiService.get().getProgramService().getPrograms());
    }
}

