/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.SavedActionSearchNavigateItem;
import org.eclipse.osee.ats.ide.search.AtsSearchWorkflowSearchItem;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public final class SaveSearchAction
extends Action {
    private final AtsSearchWorkflowSearchItem searchItem;

    public SaveSearchAction(AtsSearchWorkflowSearchItem searchItem) {
        this.searchItem = searchItem;
    }

    public String getText() {
        return "Save Search";
    }

    public String getToolTipText() {
        return "Enter search criteria and select to save";
    }

    public void run() {
        AtsUser asUser = AtsApiService.get().getConfigService().getCurrentUserByLoginId();
        EntryDialog dialog = new EntryDialog("Save Search", "Save Search?\n\n(edit to change Search Name)");
        dialog.setEntry(this.searchItem.getSearchName());
        if (dialog.open() == 0) {
            if (!Strings.isValid((String)dialog.getEntry())) {
                AWorkbench.popup((String)"Invalid Search Name");
                return;
            }
            AtsSearchData data = AtsApiService.get().getQueryService().createSearchData(this.searchItem.getNamespace(), this.searchItem.getSearchName());
            this.searchItem.loadSearchData(data);
            data.setSearchName(dialog.getEntry());
            if (data.getId() <= 0L) {
                data.setId(Lib.generateArtifactIdAsInt().longValue());
            }
            Conditions.checkExpressionFailOnTrue((data.getId() <= 0L ? 1 : 0) != 0, (String)"searchId must be > 0, not %d", (Object[])new Object[]{data.getId()});
            Conditions.checkNotNullOrEmpty((String)data.getSearchName(), (String)"Search Name");
            AtsApiService.get().getQueryService().saveSearch(asUser, data);
            SavedActionSearchNavigateItem.refreshItems();
            AWorkbench.popupf((String)"Search [%s] Saved", (Object[])new Object[]{data.getSearchName()});
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.SAVE);
    }
}

