/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.util;

import java.util.Arrays;
import java.util.Date;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.IAtsColumnId;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.log.IAtsLog;
import org.eclipse.osee.ats.api.workflow.log.ILogStorageProvider;
import org.eclipse.osee.ats.api.workflow.note.NoteItem;
import org.eclipse.osee.ats.core.column.AtsColumnId;
import org.eclipse.osee.ats.core.util.HoursSpentUtil;
import org.eclipse.osee.ats.core.util.PercentCompleteTotalUtil;
import org.eclipse.osee.ats.core.workflow.log.AtsLogUtility;
import org.eclipse.osee.ats.core.workflow.util.ChangeTypeUtil;
import org.eclipse.osee.ats.ide.column.DeadlineColumn;
import org.eclipse.osee.ats.ide.editor.tab.workflow.widget.ReviewInfoXWidget;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workdef.StateXWidgetPage;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.WorkflowManager;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.jdk.core.result.Manipulations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;

public class WfePrint
extends Action {
    private final AbstractWorkflowArtifact sma;
    boolean includeTaskList = true;
    private final String normalColor = "#FFFFFF";
    private final String activeColor = "#EEEEEE";

    public WfePrint(AbstractWorkflowArtifact sma) {
        this.sma = sma;
    }

    public void run() {
        try {
            XResultData xResultData = this.getResultData();
            XResultDataUI.report((XResultData)xResultData, (String)("Print Preview of " + this.sma.getName()), (Manipulations[])new Manipulations[]{Manipulations.RAW_HTML});
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public XResultData getResultData() {
        XResultData resultData = new XResultData();
        resultData.addRaw(AHTML.beginMultiColumnTable((int)100));
        resultData.addRaw(AHTML.addRowMultiColumnTable((String[])new String[]{AHTML.getLabelValueStr((String)"<font color=\"black\" face=\"Arial\" size=\"-1\">", (String)"Title: ", (String)this.sma.getName())}));
        resultData.addRaw(AHTML.endMultiColumnTable());
        resultData.addRaw(AHTML.beginMultiColumnTable((int)100));
        resultData.addRaw(AHTML.addRowMultiColumnTable((String[])new String[]{AHTML.getLabelValueStr((String)"<font color=\"black\" face=\"Arial\" size=\"-1\">", (String)"Current State: ", (String)this.sma.getCurrentStateName()), AHTML.getLabelValueStr((String)"<font color=\"black\" face=\"Arial\" size=\"-1\">", (String)"Team: ", (String)AtsApiService.get().getColumnService().getColumn((IAtsColumnId)AtsColumnId.Team).getColumnText((IAtsObject)this.sma)), AHTML.getLabelValueStr((String)"<font color=\"black\" face=\"Arial\" size=\"-1\">", (String)"Assignees: ", (String)AtsApiService.get().getColumnService().getColumnText((IAtsColumnId)AtsColumnId.Assignees, (IAtsObject)this.sma)), AHTML.getLabelValueStr((String)"<font color=\"black\" face=\"Arial\" size=\"-1\">", (String)"Originator: ", (String)this.sma.getCreatedBy().getName()), AHTML.getLabelValueStr((String)"<font color=\"black\" face=\"Arial\" size=\"-1\">", (String)"Created: ", (String)DateUtil.getMMDDYYHHMM((Date)this.sma.getCreatedDate()))}));
        resultData.addRaw(AHTML.endMultiColumnTable());
        resultData.addRaw(AHTML.beginMultiColumnTable((int)100));
        resultData.addRaw(AHTML.addRowMultiColumnTable((String[])new String[]{AHTML.getLabelValueStr((String)"<font color=\"black\" face=\"Arial\" size=\"-1\">", (String)"Change Type: ", (String)ChangeTypeUtil.getChangeTypeStr((IAtsWorkItem)this.sma, (AtsApi)AtsApiService.get())), AHTML.getLabelValueStr((String)"<font color=\"black\" face=\"Arial\" size=\"-1\">", (String)"Priority: ", (String)((String)this.sma.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Priority, ""))), AHTML.getLabelValueStr((String)"<font color=\"black\" face=\"Arial\" size=\"-1\">", (String)"Need By: ", (String)DeadlineColumn.getDateStr(this.sma))}));
        String computedId = AtsApiService.get().getWorkItemService().getCombinedPcrId((IAtsWorkItem)this.sma);
        resultData.addRaw(AHTML.addRowMultiColumnTable((String[])new String[]{AHTML.getLabelValueStr((String)"<font color=\"black\" face=\"Arial\" size=\"-1\">", (String)"Workflow: ", (String)this.sma.getArtifactTypeName()), AHTML.getLabelValueStr((String)"<font color=\"black\" face=\"Arial\" size=\"-1\">", (String)"ID: ", (String)computedId)}));
        resultData.addRaw(AHTML.endMultiColumnTable());
        for (NoteItem note : AtsApiService.get().getWorkItemService().getNotes((IAtsWorkItem)this.sma).getNoteItems()) {
            if (!note.getState().equals("")) continue;
            resultData.addRaw(String.valueOf(note.toHTML()) + AHTML.newline());
        }
        this.getWorkFlowHtml(resultData);
        if (this.includeTaskList) {
            this.getTaskHtml(resultData);
        }
        resultData.addRaw(AHTML.newline());
        resultData.addRaw(AtsLogUtility.getHtml((IAtsLog)this.sma.getLog(), (ILogStorageProvider)AtsApiService.get().getLogFactory().getLogProvider((IAtsWorkItem)this.sma, AtsApiService.get().getAttributeResolver()), (IAtsUserService)AtsApiService.get().getUserService()));
        XResultData rd = new XResultData();
        rd.addRaw(AHTML.beginMultiColumnTable((int)100, (int)1));
        rd.addRaw(AHTML.addRowMultiColumnTable((String[])new String[]{XResultDataUI.getReport((XResultData)resultData, (String)"").getManipulatedHtml(Arrays.asList(Manipulations.NONE))}));
        rd.addRaw(AHTML.endMultiColumnTable());
        return rd;
    }

    private void getTaskHtml(XResultData rd) {
        if (!(this.sma instanceof TeamWorkFlowArtifact)) {
            return;
        }
        try {
            rd.addRaw(String.valueOf(AHTML.addSpace((int)1)) + AHTML.getLabelStr((String)"<font color=\"black\" face=\"Arial\" size=\"-1\">", (String)"Tasks"));
            rd.addRaw(AHTML.startBorderTable((int)100, (String)"#EEEEEE", (String)""));
            rd.addRaw(AHTML.addHeaderRowMultiColumnTable((String[])new String[]{"Title", "State", "POC", "%", "Hrs", "Resolution", "ID"}));
            for (IAtsTask task : AtsApiService.get().getTaskService().getTasks((IAtsTeamWorkflow)((TeamWorkFlowArtifact)this.sma))) {
                TaskArtifact art = (TaskArtifact)task;
                rd.addRaw(AHTML.addRowMultiColumnTable((String[])new String[]{art.getName(), art.getStateMgr().getCurrentStateName().replaceAll("(Task|State)", ""), AtsApiService.get().getColumnService().getColumnText((IAtsColumnId)AtsColumnId.Assignees, (IAtsObject)art), String.valueOf(PercentCompleteTotalUtil.getPercentCompleteTotal((IAtsObject)art, (AtsApi)AtsApiService.get())), String.valueOf(HoursSpentUtil.getHoursSpentTotal((IAtsObject)art, (AtsApi)AtsApiService.get())), (String)art.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Resolution, ""), art.getAtsId()}));
            }
            rd.addRaw(AHTML.endBorderTable());
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            rd.addRaw("Task Exception - " + ex.getLocalizedMessage());
        }
    }

    private void getWorkFlowHtml(XResultData rd) {
        for (StateXWidgetPage statePage : WorkflowManager.getStatePagesOrderedByOrdinal(this.sma)) {
            if (!this.sma.isInState(statePage) && !this.sma.getStateMgr().isStateVisited((IStateToken)statePage) || statePage.getStateType().isCompletedState() && !this.sma.isCompleted() || statePage.getStateType().isCancelledState() && !this.sma.isCancelled()) continue;
            StringBuffer notesSb = new StringBuffer();
            for (NoteItem note : AtsApiService.get().getWorkItemService().getNotes((IAtsWorkItem)this.sma).getNoteItems()) {
                if (!note.getState().equals(statePage.getName())) continue;
                notesSb.append(note.toHTML());
                notesSb.append(AHTML.newline());
            }
            if (!this.sma.isInState(statePage) && !this.sma.getStateMgr().isStateVisited((IStateToken)statePage)) continue;
            statePage.generateLayoutDatas();
            rd.addRaw(statePage.getHtml(this.sma.isInState(statePage) ? "#EEEEEE" : "#FFFFFF", notesSb.toString(), String.valueOf(this.getStateHoursSpentHtml(statePage)) + this.getReviewData(this.sma, statePage)));
            rd.addRaw(AHTML.newline());
        }
    }

    private String getReviewData(AbstractWorkflowArtifact sma, StateXWidgetPage page) {
        if (sma.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            return ReviewInfoXWidget.toHTML((TeamWorkFlowArtifact)sma, page);
        }
        return "";
    }

    private String getStateHoursSpentHtml(StateXWidgetPage statePage) {
        return AHTML.getLabelValueStr((String)"State Hours Spent", (String)(String.valueOf(AtsUtil.doubleToI18nString((double)this.sma.getStateMgr().getHoursSpent(statePage.getName()))) + "<br>"));
    }

    public boolean isIncludeTaskList() {
        return this.includeTaskList;
    }

    public void setIncludeTaskList(boolean includeTaskList) {
        this.includeTaskList = includeTaskList;
    }
}

