/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.config.copy;

import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class ConfigData {
    String searchStr;
    String replaceStr;
    IAtsTeamDefinition teamDef;
    IAtsActionableItem actionableItem;
    boolean retainTeamLeads;
    boolean persistChanges;
    Long newProgramId;

    public void validateData(XResultData resultData) {
        if (this.teamDef == null) {
            resultData.error("Must Select Team Definition");
        }
        if (this.actionableItem == null) {
            resultData.error("Must Select Actionable Item");
        }
        if (!Strings.isValid((String)this.searchStr)) {
            resultData.error("Must Enter Search String");
        }
        if (!Strings.isValid((String)this.replaceStr)) {
            resultData.error("Must Enter Replace String");
        }
        if (this.searchStr != null && this.replaceStr != null && this.searchStr.equals(this.replaceStr)) {
            resultData.errorf("Search string [%s] can't equal replace string [%s]", new Object[]{this.searchStr, this.replaceStr});
        }
    }

    public String getSearchStr() {
        return this.searchStr;
    }

    public void setSearchStr(String searchStr) {
        this.searchStr = searchStr;
    }

    public String getReplaceStr() {
        return this.replaceStr;
    }

    public void setReplaceStr(String replaceStr) {
        this.replaceStr = replaceStr;
    }

    public IAtsTeamDefinition getTeamDef() {
        return this.teamDef;
    }

    public void setTeamDef(IAtsTeamDefinition teamDef) {
        this.teamDef = teamDef;
    }

    public boolean isRetainTeamLeads() {
        return this.retainTeamLeads;
    }

    public void setRetainTeamLeads(boolean retainTeamLeads) {
        this.retainTeamLeads = retainTeamLeads;
    }

    public boolean isPersistChanges() {
        return this.persistChanges;
    }

    public void setPersistChanges(boolean persistChanges) {
        this.persistChanges = persistChanges;
    }

    public IAtsTeamDefinition getParentTeamDef() {
        Object parentTeamDef = null;
        parentTeamDef = AtsApiService.get().getTeamDefinitionService().getParentTeamDef(this.teamDef) != null ? AtsApiService.get().getTeamDefinitionService().getParentTeamDef(this.teamDef) : AtsApiService.get().getTeamDefinitionService().getTopTeamDefinition();
        return parentTeamDef;
    }

    public IAtsActionableItem getParentActionableItem() {
        IAtsActionableItem parentActionableItem = null;
        Collection fromAias = AtsApiService.get().getActionableItemService().getActionableItems(this.teamDef);
        parentActionableItem = fromAias.size() == 1 ? ((ActionableItem)fromAias.iterator().next()).getParentActionableItem() : AtsApiService.get().getActionableItemService().getTopActionableItem((AtsApi)AtsApiService.get());
        return parentActionableItem;
    }

    public IAtsActionableItem getActionableItem() {
        return this.actionableItem;
    }

    public void setActionableItem(IAtsActionableItem actionableItem) {
        this.actionableItem = actionableItem;
    }

    public Long getNewProgramId() {
        return this.newProgramId;
    }

    public void setNewProgramId(Long newProgramId) {
        this.newProgramId = newProgramId;
    }
}

