/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;

public class ParentAtsIdColumn
extends XViewerAtsColumn
implements IXViewerValueColumn {
    public static ParentAtsIdColumn instance = new ParentAtsIdColumn();

    public static ParentAtsIdColumn getInstance() {
        return instance;
    }

    private ParentAtsIdColumn() {
        super("ats.column.parentatsid", "Parent ATS ID", 75, XViewerAlign.Left, false, SortDataType.String, false, "ATS ID of Parent Action or Team Workflow");
    }

    public ParentAtsIdColumn copy() {
        ParentAtsIdColumn newXCol = new ParentAtsIdColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        try {
            if (Artifacts.isOfType((Object)element, (ArtifactTypeToken)AtsArtifactTypes.TeamWorkflow)) {
                IAtsAction parentAction = (IAtsAction)((TeamWorkFlowArtifact)((Object)element)).getParentAction().getStoreObject();
                if (parentAction != null) {
                    return parentAction.getAtsId();
                }
            } else if (element instanceof AbstractWorkflowArtifact && ((AbstractWorkflowArtifact)((Object)element)).getParentAWA() != null) {
                return ((AbstractWorkflowArtifact)((Object)element)).getParentAWA().getAtsId();
            }
        }
        catch (OseeCoreException ex) {
            return LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
        return "";
    }
}

