/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.IAltLeftClickProvider;
import org.eclipse.nebula.widgets.xviewer.IMultiColumnEditProvider;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.column.AtsColumnToken;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.UserCheckTreeDialog;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumnIdColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkArtifactImageProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class AssigneeColumnUI
extends XViewerAtsColumnIdColumn
implements IAltLeftClickProvider,
IMultiColumnEditProvider {
    public static AssigneeColumnUI instance = new AssigneeColumnUI();

    public static AssigneeColumnUI getInstance() {
        return instance;
    }

    private AssigneeColumnUI() {
        super(AtsColumnToken.AssigneeColumn);
    }

    @Override
    public XViewerAtsColumnIdColumn copy() {
        AssigneeColumnUI newXCol = new AssigneeColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        try {
            IAtsWorkItem workItem = null;
            boolean modified = false;
            XViewer xViewer = null;
            if (treeItem.getData() instanceof IAtsAction) {
                if (AtsApiService.get().getWorkItemService().getTeams(workItem).size() != 1) {
                    return false;
                }
                workItem = AtsApiService.get().getWorkItemService().getFirstTeam((Object)workItem);
            } else if (treeItem.getData() instanceof IAtsWorkItem) {
                workItem = (IAtsWorkItem)treeItem.getData();
            }
            if (workItem == null) {
                return false;
            }
            modified = AssigneeColumnUI.promptChangeAssignees(Arrays.asList(workItem), this.isPersistViewer());
            xViewer = (XViewer)((XViewerColumn)treeColumn.getData()).getXViewer();
            if (modified && this.isPersistViewer(xViewer)) {
                AtsApiService.get().getStoreService().executeChangeSet("persist assignees via alt-left-click", (IAtsObject)workItem);
            }
            if (!modified) return false;
            xViewer.update((Object)workItem.getStoreObject(), null);
            return true;
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return false;
    }

    public static boolean promptChangeAssignees(IAtsWorkItem workItem, boolean persist) {
        return AssigneeColumnUI.promptChangeAssignees(Arrays.asList(workItem), persist);
    }

    public static boolean promptChangeAssignees(Collection<? extends IAtsWorkItem> workItems, boolean persist) {
        for (IAtsWorkItem iAtsWorkItem : workItems) {
            if (iAtsWorkItem.isCompleted()) {
                AWorkbench.popup((String)"ERROR", (String)("Can't assign completed " + iAtsWorkItem.getArtifactTypeName() + " (" + iAtsWorkItem.getAtsId() + ")"));
                return false;
            }
            if (!iAtsWorkItem.isCancelled()) continue;
            AWorkbench.popup((String)"ERROR", (String)("Can't assign cancelled " + iAtsWorkItem.getArtifactTypeName() + " (" + iAtsWorkItem.getAtsId() + ")"));
            return false;
        }
        Collection collection = AtsApiService.get().getUserService().getActiveAndAssignedInActive(workItems);
        collection.remove(AtsCoreUsers.UNASSIGNED_USER);
        collection.remove(AtsCoreUsers.BOOTSTRAP_USER);
        UserCheckTreeDialog uld = new UserCheckTreeDialog("Select Assignees", "Select to assign.\nDeSelect to un-assign.", collection);
        uld.setIncludeAutoSelectButtons(true);
        IAtsTeamWorkflow parentWorklfow = workItems.iterator().next().getParentTeamWorkflow();
        if (parentWorklfow != null) {
            uld.setTeamMembers(AtsApiService.get().getTeamDefinitionService().getMembersAndLeads(parentWorklfow.getTeamDefinition()));
        }
        if (workItems.size() == 1) {
            uld.setInitialSelections(workItems.iterator().next().getStateMgr().getAssignees());
        }
        if (uld.open() != 0) {
            return false;
        }
        Collection<AtsUser> selected = uld.getUsersSelected();
        if (selected.isEmpty()) {
            selected.add(AtsCoreUsers.UNASSIGNED_USER);
        }
        if (selected.size() > 1) {
            collection.remove(AtsCoreUsers.UNASSIGNED_USER);
        }
        for (IAtsWorkItem iAtsWorkItem : workItems) {
            iAtsWorkItem.getStateMgr().setAssignees(selected);
        }
        if (persist) {
            AtsApiService.get().getStoreService().executeChangeSet("Assignee - Prompt Change", workItems);
        }
        return true;
    }

    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        try {
            HashSet<IAtsTeamWorkflow> teamWfs = new HashSet<IAtsTeamWorkflow>();
            for (TreeItem item : treeItems) {
                if (item.getData() instanceof IAtsTeamWorkflow) {
                    IAtsTeamWorkflow teamWf = (IAtsTeamWorkflow)item.getData();
                    if (!(teamWf instanceof AbstractWorkflowArtifact)) continue;
                    teamWfs.add(teamWf);
                    continue;
                }
                if (!(item.getData() instanceof IAtsAction)) continue;
                teamWfs.add(AtsApiService.get().getWorkItemService().getFirstTeam(item.getData()));
            }
            if (teamWfs.isEmpty()) {
                AWorkbench.popup((String)"Invalid selection for setting assignees.");
                return;
            }
            AssigneeColumnUI.promptChangeAssignees(teamWfs, true);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    @Override
    public Image getColumnImage(Object element, XViewerColumn xCol, int columnIndex) {
        try {
            if (element instanceof Artifact) {
                return AssigneeColumnUI.getAssigneeImage(AtsApiService.get().getQueryServiceIde().getArtifact(element));
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static Image getAssigneeImage(Artifact artifact) {
        if (artifact.isDeleted()) {
            return null;
        }
        if (artifact instanceof AbstractWorkflowArtifact) {
            ArrayList<User> users = new ArrayList<User>();
            for (AtsUser aUser : ((AbstractWorkflowArtifact)artifact).getStateMgr().getAssignees()) {
                User user = UserManager.getUserByArtId((ArtifactId)aUser);
                if (user == null) continue;
                users.add(user);
            }
            return FrameworkArtifactImageProvider.getUserImage(users);
        }
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams((Object)artifact)) {
                Image image = AssigneeColumnUI.getAssigneeImage(AtsApiService.get().getQueryServiceIde().getArtifact(team));
                if (image == null) continue;
                return image;
            }
        }
        return null;
    }
}

