/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.model;

import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.data.ApplicabilityData;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BlockApplicabilityStageRequest;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.ConfigurationGroupDefinition;
import org.eclipse.osee.framework.core.data.CreateViewDefinition;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Pair;

@Path(value="applic")
public interface ApplicabilityEndpoint {
    @GET
    @Produces(value={"application/json"})
    public Collection<ApplicabilityToken> getApplicabilityTokens();

    @GET
    @Path(value="all")
    @Produces(value={"application/json"})
    public Collection<String> getPossibleApplicabilities();

    @GET
    @Path(value="artifact/{artId}")
    @Produces(value={"application/json"})
    public ApplicabilityToken getApplicabilityToken(@PathParam(value="artId") ArtifactId var1);

    @GET
    @Path(value="artifact/reference/{artId}")
    @Produces(value={"application/json"})
    public List<ApplicabilityId> getApplicabilitiesReferenced(@PathParam(value="artId") ArtifactId var1);

    @GET
    @Path(value="artifact/reference/token/{artId}")
    @Produces(value={"application/json"})
    public List<ApplicabilityToken> getApplicabilityReferenceTokens(@PathParam(value="artId") ArtifactId var1);

    @GET
    @Path(value="cfggroup")
    @Produces(value={"application/json"})
    public List<ArtifactToken> getCfgGroup();

    @POST
    @Path(value="cfggroup")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData createCfgGroup(ConfigurationGroupDefinition var1);

    @PUT
    @Path(value="cfggroup")
    @Produces(value={"application/json"})
    public XResultData updateCfgGroup(ConfigurationGroupDefinition var1);

    @POST
    @Path(value="cfggroup/sync")
    @Produces(value={"application/json"})
    public XResultData syncCfgGroup();

    @DELETE
    @Path(value="cfggroup/{id}")
    @Produces(value={"application/json"})
    public XResultData deleteCfgGroup(@PathParam(value="id") String var1);

    @POST
    @Path(value="cfggroup/sync/{id}")
    @Produces(value={"application/json"})
    public XResultData syncCfgGroup(@PathParam(value="id") String var1);

    @GET
    @Path(value="cfggroup/def/{id}")
    @Produces(value={"application/json"})
    public ConfigurationGroupDefinition getConfigurationGroup(@PathParam(value="id") String var1);

    @PUT
    @Path(value="cfggroup/{groupId}/relate/{viewId}")
    @Produces(value={"application/json"})
    public XResultData relateCfgGroupToView(@PathParam(value="groupId") String var1, @PathParam(value="viewId") String var2);

    @PUT
    @Path(value="cfggroup/{groupId}/unrelate/{viewId}")
    @Produces(value={"application/json"})
    public XResultData unrelateCfgGroupToView(@PathParam(value="groupId") String var1, @PathParam(value="viewId") String var2);

    @GET
    @Path(value="features")
    @Produces(value={"application/json"})
    public List<FeatureDefinition> getFeatureDefinitionData();

    @PUT
    @Path(value="feature")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public XResultData updateFeature(FeatureDefinition var1);

    @POST
    @Path(value="feature")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData createFeature(FeatureDefinition var1);

    @GET
    @Path(value="feature/{featureNameOrId}")
    @Produces(value={"application/json"})
    public FeatureDefinition getFeature(@PathParam(value="featureNameOrId") String var1);

    @DELETE
    @Path(value="feature/{id}")
    @Produces(value={"application/json"})
    public XResultData deleteFeature(@PathParam(value="id") ArtifactId var1);

    @GET
    @Path(value="views")
    @Produces(value={"application/json"})
    public List<ArtifactToken> getViews();

    @PUT
    @Path(value="view")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData updateView(CreateViewDefinition var1);

    @POST
    @Path(value="view")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData createView(CreateViewDefinition var1);

    @GET
    @Path(value="view/{id}")
    @Produces(value={"application/json"})
    public List<ApplicabilityToken> getViewApplicabilityTokens(@PathParam(value="id") ArtifactId var1);

    @DELETE
    @Path(value="view/{id}")
    @Produces(value={"application/json"})
    public XResultData deleteView(@PathParam(value="id") String var1);

    @PUT
    @Path(value="view/{id}/applic")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public XResultData createApplicabilityForView(@PathParam(value="id") ArtifactId var1, String var2);

    @DELETE
    @Path(value="view/{id}/applic")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData removeApplicabilityFromView(@PathParam(value="id") ArtifactId var1, String var2);

    @GET
    @Path(value="view/def/{id}")
    @Produces(value={"application/json"})
    public CreateViewDefinition getView(@PathParam(value="id") String var1);

    @GET
    @Path(value="change")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<BranchId> getAffectedBranches(@QueryParam(value="injectionDateMs") Long var1, @QueryParam(value="removalDateMs") @DefaultValue(value="-1") Long var2, List<ApplicabilityId> var3);

    @PUT
    @Path(value="artifacts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<Pair<ArtifactId, ApplicabilityToken>> getApplicabilityTokens(List<? extends ArtifactId> var1);

    @GET
    @Path(value="change")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public List<BranchId> getAffectedBranches(@QueryParam(value="injectiontx") TransactionId var1, @QueryParam(value="removaltx") @DefaultValue(value="-1") TransactionId var2, List<ApplicabilityId> var3);

    @GET
    @Path(value="table")
    @Produces(value={"text/html"})
    public String getViewTable(@QueryParam(value="filter") String var1);

    @GET
    @Path(value="matrix")
    @Produces(value={"text/html"})
    public String getConfigMatrix(@QueryParam(value="matrixtype") String var1, @QueryParam(value="filter") String var2);

    @PUT
    @Path(value="{applicId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TransactionToken setApplicability(@PathParam(value="applicId") ApplicabilityId var1, List<? extends ArtifactId> var2);

    @PUT
    @Path(value="set/{applicTag}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TransactionToken setApplicabilityByString(@PathParam(value="applicTag") String var1, List<? extends ArtifactId> var2);

    @PUT
    @Path(value="artifact/reference")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TransactionToken setApplicabilityReference(List<ApplicabilityData> var1);

    @GET
    @Path(value="versionConfig/{version}")
    @Produces(value={"application/json"})
    public ArtifactId getVersionConfig(@PathParam(value="version") ArtifactId var1);

    @PUT
    @Path(value="update-from-parent")
    public void addMissingApplicabilityFromParentBranch();

    @GET
    @Path(value="access")
    @Produces(value={"application/json"})
    public XResultData isAccess();

    @GET
    @Path(value="featureMatrix")
    @Produces(value={"application/xml"})
    public Response getFeatureMatrixExcel(@PathParam(value="branch") BranchId var1, @QueryParam(value="filter") String var2);

    @POST
    @Path(value="blockVisibility")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData applyBlockVisibility(BlockApplicabilityStageRequest var1);

    @POST
    @Path(value="blockVisibility/refresh")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData refreshStagedFiles(BlockApplicabilityStageRequest var1);

    @PUT
    @Path(value="blockVisibility/startWatcher")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData startBlockVisibilityWatcher(BlockApplicabilityStageRequest var1);

    @PUT
    @Path(value="blockVisibility/stopWatcher")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public XResultData stopBlockVisibilityWatcher();

    @PUT
    @Path(value="validate")
    @Produces(value={"application/json"})
    public XResultData validate();

    @GET
    @Path(value="applicabilityToken/{id}")
    @Produces(value={"application/json"})
    public ApplicabilityToken getApplicabilityTokenFromId(@PathParam(value="id") String var1);
}

