/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.branch.graph.model;

import java.util.Date;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.TransactionDetailsType;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserManager;

public class TxData {
    private final UserId authorId;
    private final Date timeStamp;
    private final String comment;
    private final TransactionDetailsType txType;
    private final BranchId branch;
    private final Long txId;

    public TxData(BranchId branch, UserId authorId, Date timeStamp, String comment, TransactionDetailsType txType, long txId) {
        this.authorId = authorId;
        this.timeStamp = timeStamp;
        this.comment = comment;
        this.txType = txType;
        this.branch = branch;
        this.txId = txId;
    }

    public String getAuthor() {
        String authorName = null;
        try {
            User user = UserManager.getUserByArtId((ArtifactId)this.authorId);
            if (user != null) {
                authorName = user.getName();
            }
        }
        catch (OseeCoreException oseeCoreException) {
            authorName = "Unknown";
        }
        return authorName;
    }

    public Date getTimeStamp() {
        return this.timeStamp;
    }

    public String getComment() {
        return this.comment;
    }

    public TransactionDetailsType getTxType() {
        return this.txType;
    }

    public BranchId getBranch() {
        return this.branch;
    }

    public Long getTxId() {
        return this.txId;
    }

    public int hashCode() {
        return this.getTxId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof TxData) {
            TxData other = (TxData)obj;
            return other.getTxId().longValue() == this.getTxId().longValue();
        }
        return false;
    }

    public String toString() {
        return String.format("Tx:[%s] Author:[%s] Branch:[%s] Comment:[%s]", this.getTxId(), this.getAuthor(), this.getBranch(), this.getComment());
    }

    protected static TxData createTxData(TransactionRecord txId) {
        return new TxData(txId.getBranch(), txId.getAuthor(), txId.getTimeStamp(), txId.getComment(), txId.getTxType(), txId.getId());
    }
}

