/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.utility;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.sql.OseeSql;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactLoader;

public class ViewIdUtility {
    public static Set<ArtifactId> findExcludedArtifactsByView(ArtifactId viewId, BranchId branch) {
        HashSet<ArtifactId> excludedArtifactIdMap = new HashSet<ArtifactId>();
        if (viewId.isValid()) {
            Object[] objs = new Object[]{branch, viewId, branch};
            List<ArtifactId> excludedArtifacts = ArtifactLoader.selectArtifactIds(OseeSql.LOAD_EXCLUDED_ARTIFACT_IDS.getSql(), objs, 300);
            for (ArtifactId artId : excludedArtifacts) {
                excludedArtifactIdMap.add(artId);
            }
        }
        return excludedArtifactIdMap;
    }

    public static void removeExcludedArtifacts(Iterator<Artifact> iterator, Set<ArtifactId> excludedArtifactIdMap) {
        while (iterator.hasNext()) {
            Artifact artifact = iterator.next();
            if (!excludedArtifactIdMap.contains(ArtifactId.valueOf((Long)artifact.getId()))) continue;
            iterator.remove();
        }
    }
}

