/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.importing.parsers;

import java.net.URI;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.importing.RoughArtifact;
import org.eclipse.osee.framework.skynet.core.importing.operations.RoughArtifactCollector;
import org.eclipse.osee.framework.skynet.core.importing.parsers.IArtifactExtractor;
import org.eclipse.osee.framework.skynet.core.importing.parsers.IArtifactExtractorDelegate;
import org.eclipse.osee.framework.skynet.core.importing.parsers.NullDelegate;

public abstract class AbstractArtifactExtractor
implements IArtifactExtractor {
    private static final IArtifactExtractorDelegate NULL_DELEGATE = new NullDelegate();
    private IArtifactExtractorDelegate delegate = NULL_DELEGATE;

    protected AbstractArtifactExtractor() {
    }

    protected abstract void extractFromSource(OperationLogger var1, URI var2, RoughArtifactCollector var3) throws Exception;

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isDelegateRequired() {
        return false;
    }

    @Override
    public final void setDelegate(IArtifactExtractorDelegate delegate) {
        this.delegate = delegate != null ? delegate : NULL_DELEGATE;
    }

    @Override
    public final IArtifactExtractorDelegate getDelegate() {
        return this.delegate;
    }

    @Override
    public final boolean hasDelegate() {
        return !(this.delegate instanceof NullDelegate);
    }

    private void checkDelegate() {
        if (this.isDelegateRequired() && !this.hasDelegate()) {
            throw new OseeStateException("Delegate is required but is null delegate", new Object[0]);
        }
    }

    @Override
    public final void process(OperationLogger logger, URI source, RoughArtifactCollector collector) throws Exception {
        this.checkDelegate();
        this.delegate.initialize();
        try {
            this.extractFromSource(logger, source, collector);
            this.connectParentChildRelations(collector);
            this.connectCollectorParent(collector);
        }
        finally {
            this.delegate.dispose();
        }
    }

    @Override
    public boolean artifactCreated(Artifact theArtifact, RoughArtifact source) {
        return false;
    }

    private void connectCollectorParent(RoughArtifactCollector collector) {
        RoughArtifact parent = collector.getParentRoughArtifact();
        if (parent != null) {
            for (RoughArtifact roughArtifact : collector.getRoughArtifacts()) {
                if (roughArtifact.hasParent()) continue;
                parent.addChild(roughArtifact);
            }
        }
    }

    private void connectParentChildRelations(RoughArtifactCollector collector) {
        for (RoughArtifact roughArtifact : collector.getRoughArtifacts()) {
            if (!roughArtifact.hasHierarchicalRelation()) continue;
            this.connectParentChildRelationsFor(collector, roughArtifact);
        }
    }

    private void connectParentChildRelationsFor(RoughArtifactCollector collector, RoughArtifact parent) {
        for (RoughArtifact otherRoughArtifact : collector.getRoughArtifacts()) {
            if (parent.equals(otherRoughArtifact) || !parent.isChild(otherRoughArtifact)) continue;
            parent.addChild(otherRoughArtifact);
        }
    }
}

