/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.event.model;

import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.model.event.DefaultBasicGuidArtifact;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.event.model.EventModType;

public class EventBasicGuidArtifact
extends DefaultBasicGuidArtifact {
    private final EventModType eventModType;

    public EventBasicGuidArtifact(EventModType eventModType, Artifact artifact) {
        this(eventModType, (BranchId)artifact.getBranch(), artifact);
    }

    public EventBasicGuidArtifact(EventModType eventModType, ArtifactToken basicGuidArtifact) {
        this(eventModType, (BranchId)basicGuidArtifact.getBranch(), basicGuidArtifact);
    }

    public EventBasicGuidArtifact(EventModType eventModType, BranchId branch, ArtifactTypeToken artifactType, String guid) {
        super(branch, artifactType, guid);
        this.eventModType = eventModType;
    }

    public EventBasicGuidArtifact(EventModType eventModType, BranchId branch, ArtifactTypeToken artifactType) {
        super(branch, artifactType, GUID.create());
        this.eventModType = eventModType;
    }

    public EventBasicGuidArtifact(EventModType eventModType, BranchId branch, ArtifactToken artifact) {
        super(branch, artifact);
        this.eventModType = eventModType;
    }

    public EventModType getModType() {
        return this.eventModType;
    }

    public boolean equals(Object obj) {
        boolean equal = super.equals(obj);
        if (equal && obj instanceof EventBasicGuidArtifact) {
            EventBasicGuidArtifact other = (EventBasicGuidArtifact)((Object)obj);
            return this.eventModType == other.getModType();
        }
        return equal;
    }

    public String toString() {
        return String.format("[%s - G:%s - B:%s - A:%s]", new Object[]{this.eventModType, this.getGuid(), this.getBranch().getIdString(), this.getArtifactType()});
    }

    public boolean is(EventModType ... eventModTypes) {
        EventModType[] eventModTypeArray = eventModTypes;
        int n = eventModTypes.length;
        int n2 = 0;
        while (n2 < n) {
            EventModType eventModType = eventModTypeArray[n2];
            if (this.eventModType == eventModType) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

