/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.commit.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.core.util.WordCoreUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.attribute.StringAttribute;
import org.eclipse.osee.framework.skynet.core.change.AttributeChange;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.skynet.core.commit.actions.CommitAction;
import org.eclipse.osee.framework.skynet.core.revision.ChangeManager;
import org.eclipse.osee.framework.skynet.core.utility.ApplicabilityUtility;
import org.eclipse.osee.framework.skynet.core.utility.OseeInfo;

public class CatchWordMlChanges
implements CommitAction {
    @Override
    public void runCommitAction(BranchId sourceBranch, BranchId destinationBranch) {
        HashSet<Artifact> changedArtifacts = new HashSet<Artifact>();
        ArrayList<Change> changes = new ArrayList<Change>();
        IOperation operation = ChangeManager.compareTwoBranchesHead(sourceBranch, destinationBranch, changes);
        Operations.executeWorkAndCheckStatus((IOperation)operation);
        HashMap<Integer, String> trackedChanges = new HashMap<Integer, String>();
        HashMap<Integer, String> applicabilityTags = new HashMap<Integer, String>();
        for (Change change : changes) {
            Artifact artifactChanged;
            Attribute<?> attribute;
            if (change.getModificationType().isDeleted()) continue;
            if (change.getChangeType().isAttributeChange() && (attribute = ((AttributeChange)change).getAttribute()).isOfType((AttributeTypeId)CoreAttributeTypes.WordTemplateContent)) {
                Boolean useInvalidTagsCheck;
                Boolean isInvalidTags;
                if (WordCoreUtil.containsWordAnnotations((String)((StringAttribute)attribute).getValue())) {
                    trackedChanges.put(attribute.getArtifact().getArtId(), attribute.getArtifact().getSafeName());
                }
                if ((isInvalidTags = Boolean.valueOf((useInvalidTagsCheck = Boolean.valueOf(OseeInfo.getCachedValue("osee.are.applicability.tags.invalid"))) != false ? WordCoreUtil.areApplicabilityTagsInvalid((String)((StringAttribute)attribute).getValue(), (BranchId)destinationBranch, ApplicabilityUtility.getValidFeatureValuesForBranch(destinationBranch), ApplicabilityUtility.getBranchViewNamesUpperCase(destinationBranch), ApplicabilityUtility.getConfigurationGroupsUpperCase(destinationBranch)) : useInvalidTagsCheck)).booleanValue()) {
                    applicabilityTags.put(attribute.getArtifact().getArtId(), attribute.getArtifact().getSafeName());
                }
            }
            if (!(artifactChanged = change.getChangeArtifact()).isValid()) continue;
            changedArtifacts.add(artifactChanged);
        }
        String err = null;
        if (!trackedChanges.isEmpty()) {
            err = String.format("Commit Branch Failed. The following artifacts contain Tracked Changes.  Please accept or reject and turn off track changes, then recommit : [%s]\n\n", ((Object)trackedChanges).toString());
        }
        if (!applicabilityTags.isEmpty()) {
            String temp = String.format("Commit Branch Failed. The following artifacts have inconsistent start and end applicability tags or the feature value pair is not valid based on the Product Line feature definition artifact. Please fix the tags, then recommit: [%s]", ((Object)applicabilityTags).toString());
            String string = err = err == null ? temp : String.valueOf(err) + temp;
        }
        if (err != null) {
            throw new OseeCoreException(err, new Object[0]);
        }
    }
}

