/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IUserGroup;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.access.UserGroupImpl;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.orcs.rest.model.DatastoreEndpoint;

public class UserServiceImpl
implements UserService {
    private static List<IUserGroupArtifactToken> userGrps;
    private boolean loading = false;

    public IUserGroup getUserGroup(IUserGroupArtifactToken userGroup) {
        Artifact userGroupArt = null;
        if (userGroup instanceof Artifact) {
            userGroupArt = (Artifact)userGroup;
        }
        if (userGroupArt == null) {
            userGroupArt = ArtifactQuery.getArtifactFromId((ArtifactId)userGroup, (BranchId)CoreBranches.COMMON);
        }
        if (userGroupArt != null) {
            return new UserGroupImpl(userGroupArt);
        }
        throw new OseeArgumentException("parameter must be artifact", new Object[0]);
    }

    public IUserGroup getUserGroup(ArtifactToken userGroupArt) {
        return new UserGroupImpl(userGroupArt);
    }

    public static List<IUserGroupArtifactToken> getUserGrps() {
        if (userGrps == null) {
            userGrps = new ArrayList<IUserGroupArtifactToken>();
            for (Artifact userGrp : UserManager.getUser().getRelatedArtifacts(CoreRelationTypes.Users_Artifact)) {
                userGrps.add((IUserGroupArtifactToken)new UserGroupImpl(userGrp));
            }
        }
        return userGrps;
    }

    public Collection<IUserGroupArtifactToken> getMyUserGroups() {
        return UserServiceImpl.getUserGrps();
    }

    public boolean isInUserGroup(IUserGroupArtifactToken ... userGroups) {
        boolean isInGroup = false;
        Collection<IUserGroupArtifactToken> userGrps = this.getMyUserGroups();
        IUserGroupArtifactToken[] iUserGroupArtifactTokenArray = userGroups;
        int n = userGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IUserGroupArtifactToken userGroup = iUserGroupArtifactTokenArray[n2];
            if (userGrps.contains(userGroup)) {
                isInGroup = true;
                break;
            }
            ++n2;
        }
        return isInGroup;
    }

    public Collection<UserToken> getUsers(IUserGroupArtifactToken userGroup) {
        ArrayList<UserToken> users = new ArrayList<UserToken>();
        Artifact userGrpArt = ArtifactQuery.getArtifactFromToken(userGroup);
        if (userGrpArt != null && userGrpArt.isValid()) {
            List<Artifact> list = userGrpArt.getRelatedArtifacts(CoreRelationTypes.Users_User);
            for (Artifact art : list) {
                User user = (User)art;
                users.add(user);
            }
        }
        return users;
    }

    public boolean isUserMember(IUserGroupArtifactToken userGroup, Long id) {
        ArtifactToken art = ArtifactQuery.getArtifactTokenFromId((BranchId)CoreBranches.COMMON, (ArtifactId)userGroup);
        if (art.isInvalid()) {
            return false;
        }
        return this.getUserGroup(userGroup).isMember(id);
    }

    public boolean isUserMember(IUserGroupArtifactToken userGroup, ArtifactId user) {
        return this.isUserMember(userGroup, user.getId());
    }

    public UserToken getUser() {
        return UserManager.getUser();
    }

    public void setUserForCurrentThread(String loginId) {
        throw new UnsupportedOperationException();
    }

    public TransactionId createUsers(Iterable<UserToken> users, String comment) {
        DatastoreEndpoint datastoreEndpoint = ServiceUtil.getOseeClient().getDatastoreEndpoint();
        return datastoreEndpoint.createUsers(users);
    }

    public void setUserForCurrentThread(UserId accountId) {
        throw new UnsupportedOperationException();
    }

    public UserToken getUserIfLoaded() {
        if (this.loading) {
            return UserToken.SENTINEL;
        }
        return this.getUser();
    }

    public void setUserLoading(boolean loading) {
        this.loading = loading;
    }
}

