/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.viewers.actions;

import java.net.URI;
import java.util.logging.Level;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.ote.define.artifacts.ArtifactTestRunOperator;
import org.eclipse.osee.ote.ui.define.internal.Activator;
import org.eclipse.osee.ote.ui.define.utilities.SelectionHelper;
import org.eclipse.osee.ote.ui.define.viewers.actions.AbstractActionHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class OpenAssociatedOutfile
extends AbstractActionHandler {
    public OpenAssociatedOutfile(StructuredViewer viewer, String text) throws Exception {
        super(viewer, text);
    }

    public OpenAssociatedOutfile(StructuredViewer viewer, String text, ImageDescriptor image) throws Exception {
        super(viewer, text, image);
    }

    @Override
    public void updateState() {
        ArtifactTestRunOperator artifact = SelectionHelper.getInstance().getSelection(this.getViewer());
        this.setEnabled(artifact != null);
    }

    public void run() {
        ArtifactTestRunOperator operator = SelectionHelper.getInstance().getSelection(this.getViewer());
        try {
            String targetFile = operator.getOutfileUrl();
            this.openEditorUtility(new URI(targetFile));
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void openEditorUtility(final URI resource) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)EFS.getStore((URI)resource));
                }
                catch (Exception ex) {
                    OpenAssociatedOutfile.this.handleException(ex);
                }
            }
        });
    }

    private void handleException(Exception ex) {
        OseeLog.log(Activator.class, (Level)Level.WARNING, (String)"Unable to open outfile.", (Throwable)ex);
        Shell shell = AWorkbench.getActiveShell();
        MessageDialog.openError((Shell)shell, (String)"Open Outfile", (String)"Unable to open outfile.");
    }
}

