/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.reports;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.ote.define.artifacts.TestRunOperator;
import org.eclipse.osee.ote.ui.define.internal.Activator;
import org.eclipse.osee.ote.ui.define.reports.ITestRunReport;

public class HistoricalTestRunData
implements ITestRunReport {
    private static final String DATE_HEADER = "Date";
    private static final String[] PER_SCRIPT_HEADER = new String[]{"Passed", "Failed", "Total", "Status"};
    private static final DateFormat formatter = SimpleDateFormat.getDateTimeInstance(3, 3);
    private final HashMap<Date, Map<String, TestRunOperator>> runByCollection = new HashMap();
    private final Set<String> runsByName = new TreeSet<String>();

    @Override
    public void gatherData(IProgressMonitor monitor, TestRunOperator ... artifacts) throws Exception {
        this.clear();
        TestRunOperator[] testRunOperatorArray = artifacts;
        int n = artifacts.length;
        int n2 = 0;
        while (n2 < n) {
            TestRunOperator operator = testRunOperatorArray[n2];
            try {
                Date date = operator.getEndDate();
                Map<String, TestRunOperator> theMap = this.runByCollection.get(date);
                if (theMap == null) {
                    theMap = new HashMap<String, TestRunOperator>();
                    this.runByCollection.put(date, theMap);
                }
                String name = operator.getScriptSimpleName();
                theMap.put(name, operator);
                this.runsByName.add(name);
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
            ++n2;
        }
    }

    @Override
    public String[][] getBody() {
        String[][] toReturn = new String[this.runByCollection.size() + 1][this.getHeader().length];
        int index = 0;
        toReturn[index++] = this.getTitleRow();
        ArrayList<Date> dateList = new ArrayList<Date>(this.runByCollection.keySet());
        Collections.sort(dateList);
        for (Date date : dateList) {
            Map<String, TestRunOperator> theMap = this.runByCollection.get(date);
            toReturn[index++] = this.getRow(date, theMap);
        }
        return toReturn;
    }

    private String[] getRow(Date date, Map<String, TestRunOperator> theMap) {
        ArrayList<String> row = new ArrayList<String>();
        row.add(formatter.format(date));
        for (String name : this.runsByName) {
            TestRunOperator operator = theMap.get(name);
            String[] stringArray = this.getData(operator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                row.add(entry);
                ++n2;
            }
        }
        return row.toArray(new String[row.size()]);
    }

    private String[] getData(TestRunOperator operator) {
        Object[] data = new String[PER_SCRIPT_HEADER.length];
        Arrays.fill(data, " ");
        try {
            if (operator != null) {
                data[0] = Integer.toString(operator.getTestPointsPassed());
                data[1] = Integer.toString(operator.getTestPointsFailed());
                data[2] = Integer.toString(operator.getTotalTestPoints());
                data[3] = operator.getTestResultStatus();
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return data;
    }

    private String[] getTitleRow() {
        ArrayList<String> header = new ArrayList<String>();
        header.add(" ");
        int index = 0;
        while (index < this.runsByName.size()) {
            header.addAll(Arrays.asList(PER_SCRIPT_HEADER));
            ++index;
        }
        return header.toArray(new String[header.size()]);
    }

    @Override
    public String getDescription() {
        return "Creates a table of run results by date.";
    }

    @Override
    public String[] getHeader() {
        ArrayList<String> header = new ArrayList<String>();
        header.add(DATE_HEADER);
        for (String name : this.runsByName) {
            header.add(name);
            header.add(" ");
            header.add(" ");
            header.add(" ");
        }
        return header.toArray(new String[header.size()]);
    }

    @Override
    public String getTitle() {
        return "Test Run Historical Trend";
    }

    @Override
    public void clear() {
        this.runByCollection.clear();
        this.runsByName.clear();
    }
}

