/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.activity.internal.jaxrs;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.eclipse.osee.activity.ActivityConstants;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.framework.core.data.OseeClient;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.logger.Log;

@Provider
public class ActivityLogResponseFilter
implements ContainerResponseFilter {
    private Log logger;
    private ActivityLog activityLog;

    public void setActivityLogger(ActivityLog activityLog) {
        this.activityLog = activityLog;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        if (this.activityLog.isEnabled()) {
            try {
                Long entryId = (Long)requestContext.getProperty("X-osee-activity-log-entryId");
                if (entryId != null) {
                    Response.StatusType statusType = responseContext.getStatusInfo();
                    if (statusType.getFamily() == Response.Status.Family.SUCCESSFUL) {
                        this.activityLog.completeEntry(entryId);
                    } else {
                        this.activityLog.endEntryAbnormally(entryId, Integer.valueOf(responseContext.getStatus()));
                    }
                } else {
                    this.activityLog.createActivityThread(CoreActivityTypes.JAXRS_METHOD_CALL_FILTER_ERROR, (UserId)SystemUser.Anonymous, Long.valueOf(OseeClient.getPort()), ActivityConstants.DEFAULT_CLIENT_ID, new Object[]{"Error [X-osee-activity-log-entryId] was missing from request http header"});
                }
            }
            catch (Throwable th) {
                this.logger.error(th, "Error during ActivityContainerResponseFilter", new Object[0]);
            }
        }
        this.activityLog.removeActivityThread();
    }
}

