/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.config.JaxNamedId;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.insertion.IAtsInsertion;
import org.eclipse.osee.ats.api.insertion.IAtsInsertionActivity;
import org.eclipse.osee.ats.api.insertion.JaxInsertion;
import org.eclipse.osee.ats.api.insertion.JaxInsertionActivity;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.rest.internal.agile.operations.ProgramOperations;
import org.eclipse.osee.ats.rest.util.AbstractConfigResource;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.orcs.OrcsApi;

@Path(value="program")
public class ProgramResource
extends AbstractConfigResource {
    @Context
    private UriInfo uriInfo;
    private ProgramOperations programOperations;

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public ProgramResource(AtsApi atsApi, OrcsApi orcsApi) {
        super(AtsArtifactTypes.Program, atsApi, orcsApi);
    }

    @GET
    @Path(value="version")
    @Produces(value={"application/json"})
    public List<JaxNamedId> getProgramsVersions() {
        LinkedList<JaxNamedId> programsVers = new LinkedList<JaxNamedId>();
        for (IAtsProgram program : this.atsApi.getProgramService().getPrograms()) {
            for (IAtsVersion ver : this.atsApi.getProgramService().getVersions(program)) {
                programsVers.add(JaxNamedId.construct((Long)ver.getId(), (String)String.format("%s - %s", program.getName(), ver.getName())));
            }
        }
        return programsVers;
    }

    @GET
    @Path(value="{id}/insertion")
    @Produces(value={"application/json"})
    public Response getProgramInsertions(@PathParam(value="id") long id) {
        ArtifactToken programArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(id));
        if (programArt == null) {
            throw new OseeCoreException("Given id not found", new Object[0]);
        }
        if (!programArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Program})) {
            throw new OseeCoreException("Given id not program type", new Object[0]);
        }
        Collection results = this.atsApi.getRelationResolver().getRelated((ArtifactId)programArt, AtsRelationTypes.ProgramToInsertion_Insertion);
        LinkedList<IAtsInsertion> insertions = new LinkedList<IAtsInsertion>();
        for (ArtifactToken insertion : results) {
            insertions.add(this.atsApi.getProgramService().getInsertion(insertion.getId()));
        }
        GenericEntity<List<IAtsConfigObject>> entity = new GenericEntity<List<IAtsConfigObject>>(insertions){};
        return Response.ok((Object)entity).build();
    }

    @POST
    @Path(value="{programId}/insertion")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createInsertion(@PathParam(value="programId") long programId, JaxInsertion newInsertion) {
        ArtifactToken programArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(programId));
        if (programArt == null) {
            throw new OseeCoreException("Given id not found", new Object[0]);
        }
        if (!programArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Program})) {
            throw new OseeCoreException("Given id not program type", new Object[0]);
        }
        ArtifactToken artifact = this.atsApi.getQueryService().getArtifact(newInsertion.getId());
        if (artifact != null) {
            throw new OseeStateException("Insertion with id %d already exists", new Object[]{newInsertion.getId()});
        }
        IAtsInsertion created = this.getProgramOperations().createInsertion((ArtifactId)programArt, newInsertion);
        return this.getResponse((IAtsConfigObject)created);
    }

    ProgramOperations getProgramOperations() {
        if (this.programOperations == null) {
            this.programOperations = new ProgramOperations(this.atsApi);
        }
        return this.programOperations;
    }

    @PUT
    @Path(value="{programId}/insertion")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateInsertion(@PathParam(value="programId") long programId, JaxInsertion insertion) {
        ArtifactToken insertionArt = this.atsApi.getQueryService().getArtifact(insertion.getId());
        if (insertionArt == null) {
            throw new OseeCoreException("Given insertion id not found", new Object[0]);
        }
        if (!insertionArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Insertion})) {
            throw new OseeCoreException("Given insertion id not insertion type", new Object[0]);
        }
        Response response = null;
        if (!insertionArt.getName().equals(insertion.getName())) {
            IAtsInsertion updated = this.getProgramOperations().updateInsertion(insertion);
            response = Response.ok().entity((Object)updated).build();
        } else {
            response = Response.notModified().build();
        }
        return response;
    }

    @GET
    @Path(value="{programId}/insertion/{id}")
    @Produces(value={"application/json"})
    public Response getInsertionDetails(@PathParam(value="programId") long programId, @PathParam(value="id") long id) {
        ArtifactToken configArt = this.atsApi.getQueryService().getArtifact(Long.valueOf(id));
        if (configArt == null) {
            throw new OseeCoreException("Given id not found", new Object[0]);
        }
        return Response.ok().entity((Object)this.atsApi.getProgramService().getInsertion(configArt.getId())).build();
    }

    @DELETE
    @Path(value="{programId}/insertion/{insertionId}")
    public Response deleteInsertion(@PathParam(value="insertionId") ArtifactId insertionId) {
        this.getProgramOperations().deleteInsertion(insertionId);
        return Response.ok().build();
    }

    @GET
    @Path(value="{programId}/insertion/{insertionId}/activity")
    @Produces(value={"application/json"})
    public Response getInsertionActivitys(@PathParam(value="programId") long programId, @PathParam(value="insertionId") long insertionId) {
        ArtifactToken insertion = this.atsApi.getQueryService().getArtifact(Long.valueOf(insertionId));
        if (insertion == null) {
            throw new OseeCoreException("Given insertion id not found", new Object[0]);
        }
        if (!insertion.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Insertion})) {
            throw new OseeCoreException("Given id not insertion type", new Object[0]);
        }
        Collection results = this.atsApi.getRelationResolver().getRelated((ArtifactId)insertion, AtsRelationTypes.InsertionToInsertionActivity_InsertionActivity);
        LinkedList<IAtsInsertionActivity> insertionActivitys = new LinkedList<IAtsInsertionActivity>();
        for (ArtifactToken insertionActivity : results) {
            insertionActivitys.add(this.atsApi.getProgramService().getInsertionActivityById((ArtifactId)insertionActivity));
        }
        GenericEntity<List<IAtsConfigObject>> entity = new GenericEntity<List<IAtsConfigObject>>(insertionActivitys){};
        return Response.ok((Object)entity).build();
    }

    @POST
    @Path(value="{programId}/insertion/{insertionId}/activity")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createInsertionActivity(@PathParam(value="programId") long programId, @PathParam(value="insertionId") long insertionId, JaxInsertionActivity newActivity) {
        ArtifactToken insertion = this.atsApi.getQueryService().getArtifact(Long.valueOf(insertionId));
        if (insertion == null) {
            throw new OseeCoreException("Given insertion id not found", new Object[0]);
        }
        if (!insertion.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Insertion})) {
            throw new OseeCoreException("Given id not insertion type", new Object[0]);
        }
        ArtifactToken artifact = this.atsApi.getQueryService().getArtifact(newActivity.getId());
        if (artifact != null) {
            throw new OseeStateException("Insertion Activity with id %d already exists", new Object[]{newActivity.getId()});
        }
        IAtsInsertionActivity created = this.getProgramOperations().createInsertionActivity((ArtifactId)insertion, newActivity);
        return this.getResponse((IAtsConfigObject)created);
    }

    @PUT
    @Path(value="{programId}/insertion/{insertionId}/activity")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateInsertionActivity(@PathParam(value="programId") long programId, @PathParam(value="insertionId") long insertionId, JaxInsertionActivity newActivity) {
        ArtifactToken insertionActivityArt = this.atsApi.getQueryService().getArtifact(newActivity.getId());
        if (insertionActivityArt == null) {
            throw new OseeCoreException("Given insertion activity id not found", new Object[0]);
        }
        if (!insertionActivityArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.InsertionActivity})) {
            throw new OseeCoreException("Given insertion activity id not insertion activity type", new Object[0]);
        }
        Response response = null;
        if (!insertionActivityArt.getName().equals(newActivity.getName())) {
            IAtsInsertionActivity updated = this.getProgramOperations().updateInsertionActivity(newActivity);
            response = Response.ok().entity((Object)updated).build();
        } else {
            response = Response.notModified().build();
        }
        return response;
    }

    @GET
    @Path(value="{programId}/insertion/{insertionId}/activity/{iaId}")
    @Produces(value={"application/json"})
    public Response getInsertionActivityDetails(@PathParam(value="programId") long programId, @PathParam(value="insertionId") long insertionId, @PathParam(value="iaId") ArtifactId iaId) {
        return Response.ok().entity((Object)this.atsApi.getProgramService().getInsertionActivityById(iaId)).build();
    }

    @DELETE
    @Path(value="{programId}/insertion/{insertionId}/activity/{iaId}")
    public Response deleteInsertionActivity(@PathParam(value="iaId") ArtifactId iaId) {
        this.getProgramOperations().deleteInsertionActivity(iaId);
        return Response.ok().build();
    }

    private Response getResponse(IAtsConfigObject config) {
        UriBuilder builder = this.uriInfo.getRequestUriBuilder();
        URI location = builder.path(config.getIdString()).build(new Object[0]);
        Response response = Response.created((URI)location).entity((Object)config).build();
        return response;
    }
}

