/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.orcs.core.ds.OptionsUtil;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.core.ds.QueryEngine;
import org.eclipse.osee.orcs.core.internal.search.TransactionCriteriaFactory;
import org.eclipse.osee.orcs.core.internal.search.TxQueryBuilderImpl;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.search.TransactionQuery;

public class TransactionQueryImpl
extends TxQueryBuilderImpl<TransactionQuery>
implements TransactionQuery {
    private final QueryEngine queryEngine;

    public TransactionQueryImpl(QueryEngine queryEngine, TransactionCriteriaFactory criteriaFactory, QueryData queryData) {
        super(criteriaFactory, queryData);
        this.queryEngine = queryEngine;
    }

    public ResultSet<TransactionReadable> getResults() {
        ArrayList txs = new ArrayList();
        this.query(txs);
        return ResultSets.newResultSet(txs);
    }

    public ResultSet<TransactionToken> getTokens() {
        ArrayList txs = new ArrayList();
        this.query(txs);
        return ResultSets.newResultSet(txs);
    }

    public ResultSet<TransactionId> getResultsAsIds() {
        ArrayList txs = new ArrayList();
        this.query(txs);
        return ResultSets.newResultSet(txs);
    }

    private void query(List<? super TransactionReadable> txs) {
        QueryData queryData = this.build();
        OptionsUtil.setLoadLevel(queryData.getOptions(), LoadLevel.ALL);
        this.queryEngine.runTxQuery(queryData, txs);
    }

    public int getCount() {
        return this.queryEngine.getTxCount(this.build());
    }

    public boolean exists() {
        return this.getCount() > 0;
    }
}

