/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.types;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.annotations.OseeArtifactAttribute;
import org.eclipse.osee.mim.annotations.OseeArtifactRequiredAttribute;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.PLGenericDBObject;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class InterfaceStructureToken
extends PLGenericDBObject {
    public static final InterfaceStructureToken SENTINEL = new InterfaceStructureToken();
    @OseeArtifactRequiredAttribute
    @OseeArtifactAttribute(attributeId=0x1000000000000070L)
    private String Name;
    @OseeArtifactAttribute(attributeId=2455059983007225764L)
    private String InterfaceStructureCategory;
    @OseeArtifactAttribute(attributeId=2455059983007225755L)
    private String InterfaceMinSimultaneity;
    @OseeArtifactAttribute(attributeId=2455059983007225756L)
    private String InterfaceMaxSimultaneity;
    @OseeArtifactAttribute(attributeId=2455059983007225760L)
    private Integer InterfaceTaskFileType;
    @OseeArtifactAttribute(attributeId=1152921504606847090L)
    private String Description;
    private Integer numElements = 0;
    private Double sizeInBytes = 0.0;
    private Double BytesPerSecondMinimum = 0.0;
    private Double BytesPerSecondMaximum = 0.0;
    private Collection<InterfaceStructureElementToken> elements = new LinkedList<InterfaceStructureElementToken>();
    private ApplicabilityToken applicability;

    public InterfaceStructureToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public InterfaceStructureToken(ArtifactReadable art) {
        this();
        this.setId(art.getId());
        this.setName(art.getName());
        this.setDescription((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Description, (Object)""));
        this.setInterfaceMaxSimultaneity((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceMaxSimultaneity, (Object)""));
        this.setInterfaceMinSimultaneity((String)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceMinSimultaneity, (Object)""));
        this.setInterfaceStructureCategory(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.InterfaceStructureCategory, ""));
        this.setInterfaceTaskFileType((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InterfaceTaskFileType, (Object)0));
        this.setNumElements(art.getRelatedCount(CoreRelationTypes.InterfaceStructureContent_DataElement));
    }

    public InterfaceStructureToken(Long id, String name) {
        super(id, name);
    }

    public InterfaceStructureToken() {
    }

    public String getInterfaceStructureCategory() {
        return this.InterfaceStructureCategory;
    }

    public void setInterfaceStructureCategory(String interfaceStructureCategory) {
        this.InterfaceStructureCategory = interfaceStructureCategory;
    }

    public String getInterfaceMinSimultaneity() {
        return this.InterfaceMinSimultaneity;
    }

    public void setInterfaceMinSimultaneity(String interfaceMinSimultaneity) {
        this.InterfaceMinSimultaneity = interfaceMinSimultaneity;
    }

    public String getInterfaceMaxSimultaneity() {
        return this.InterfaceMaxSimultaneity;
    }

    public void setInterfaceMaxSimultaneity(String interfaceMaxSimultaneity) {
        this.InterfaceMaxSimultaneity = interfaceMaxSimultaneity;
    }

    public Integer getInterfaceTaskFileType() {
        return this.InterfaceTaskFileType;
    }

    public void setInterfaceTaskFileType(Integer interfaceTaskFileType) {
        this.InterfaceTaskFileType = interfaceTaskFileType;
    }

    public String getDescription() {
        return this.Description;
    }

    public void setDescription(String description) {
        this.Description = description;
    }

    public List<InterfaceStructureElementToken> getElements() {
        return (List)this.elements;
    }

    public void setElements(Collection<InterfaceStructureElementToken> elements) {
        this.elements = elements;
    }

    public Integer getNumElements() {
        return this.numElements;
    }

    public void setNumElements(Integer numElements) {
        this.numElements = numElements;
    }

    public Double getSizeInBytes() {
        return this.sizeInBytes;
    }

    public void setSizeInBytes(Double sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
        this.setBytesPerSecondMaximum(this.sizeInBytes * Double.parseDouble(this.getInterfaceMaxSimultaneity()));
        this.setBytesPerSecondMinimum(this.sizeInBytes * Double.parseDouble(this.getInterfaceMinSimultaneity()));
    }

    public Double getBytesPerSecondMaximum() {
        return this.BytesPerSecondMaximum;
    }

    public void setBytesPerSecondMaximum(Double bytesPerSecondMaximum) {
        this.BytesPerSecondMaximum = bytesPerSecondMaximum;
    }

    public Double getBytesPerSecondMinimum() {
        return this.BytesPerSecondMinimum;
    }

    public void setBytesPerSecondMinimum(Double bytesPerSecondMinimum) {
        this.BytesPerSecondMinimum = bytesPerSecondMinimum;
    }

    public ApplicabilityToken getApplicability() {
        return this.applicability;
    }

    public void setApplicability(ApplicabilityToken applicability) {
        this.applicability = applicability;
    }
}

