/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.internal.wordupdate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.util.JsonUtil;
import org.eclipse.osee.framework.core.util.WordCoreUtil;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class ApplicabilityExpression {
    private String content;
    private String elseContent;
    private final String configuration;
    private final HashCollection<String, String> featureValuesAllowed;
    private static ScriptEngineManager sem = new ScriptEngineManager();
    private static ScriptEngine se = sem.getEngineByName("JavaScript");

    public ApplicabilityExpression(String configuration, HashCollection<String, String> featureValuesAllowed) {
        this.configuration = configuration;
        this.featureValuesAllowed = featureValuesAllowed;
    }

    public String getValidConfigurationContent(String text, ArrayList<String> configurations) {
        this.parseContent(text, false);
        String toReturn = this.elseContent;
        for (String config : configurations) {
            if (!this.configuration.equals(config)) continue;
            toReturn = this.content;
        }
        return toReturn;
    }

    public String getValidFeatureContent(String text, HashMap<String, List<String>> featureIdValuesMap, ArrayList<String> featureOperators, ArtifactReadable featureDefArt) {
        this.parseContent(text, true);
        String toReturn = null;
        String expression = this.createFeatureExpression(featureIdValuesMap, featureOperators, featureDefArt);
        boolean result = false;
        try {
            result = (Boolean)se.eval(expression);
        }
        catch (ScriptException scriptException) {
            throw new OseeCoreException("Failed to parse expression: " + expression, new Object[0]);
        }
        toReturn = result ? this.content : this.elseContent;
        return toReturn;
    }

    private void parseContent(String text, boolean isFeature) {
        this.content = text;
        this.elseContent = null;
        Matcher match = WordCoreUtil.ELSE_PATTERN.matcher(text);
        if (match.find()) {
            this.content = text.substring(0, match.start());
            this.elseContent = text.substring(match.end());
            if (isFeature) {
                this.elseContent = this.elseContent.replaceAll(WordCoreUtil.ENDFEATURE, "");
                this.elseContent = this.elseContent.replaceAll(WordCoreUtil.BEGINFEATURE, "");
            } else {
                this.elseContent = this.elseContent.replaceAll(WordCoreUtil.ENDCONFIG, "");
                this.elseContent = this.elseContent.replaceAll(WordCoreUtil.BEGINCONFIG, "");
            }
        }
        if (isFeature) {
            this.content = this.content.replaceAll(WordCoreUtil.ENDFEATURE, "");
            this.content = this.content.replaceAll(WordCoreUtil.BEGINFEATURE, "");
        } else {
            this.content = this.content.replaceAll(WordCoreUtil.ENDCONFIG, "");
            this.content = this.content.replaceAll(WordCoreUtil.BEGINCONFIG, "");
        }
    }

    private String createFeatureExpression(HashMap<String, List<String>> featureIdValuesMap, ArrayList<String> featureOperators, ArtifactReadable featureDefArt) {
        String myFeatureExpression = "";
        Iterator<String> iterator = featureOperators.iterator();
        for (String feature : featureIdValuesMap.keySet()) {
            List<String> values = featureIdValuesMap.get(feature);
            String valueExpression = this.createValueExpression(feature, values, featureDefArt);
            boolean result = false;
            try {
                result = (Boolean)se.eval(valueExpression);
            }
            catch (ScriptException scriptException) {
                throw new OseeCoreException("Failed to parse expression: " + valueExpression, new Object[0]);
            }
            myFeatureExpression = String.valueOf(myFeatureExpression) + result + " ";
            if (!iterator.hasNext()) continue;
            String next = iterator.next();
            if (next.equals("|")) {
                myFeatureExpression = String.valueOf(myFeatureExpression) + "|| ";
                continue;
            }
            if (!next.equals("&")) continue;
            myFeatureExpression = String.valueOf(myFeatureExpression) + "&& ";
        }
        return myFeatureExpression;
    }

    private String createValueExpression(String feature, List<String> values, ArtifactReadable featureDefArt) {
        String myValueExpression = "";
        for (String value : values) {
            if (value.equals("(")) {
                myValueExpression = String.valueOf(myValueExpression) + "( ";
                continue;
            }
            if (value.equals(")")) {
                myValueExpression = String.valueOf(myValueExpression) + ") ";
                continue;
            }
            if (value.equals("|")) {
                myValueExpression = String.valueOf(myValueExpression) + "|| ";
                continue;
            }
            if (value.equals("&")) {
                myValueExpression = String.valueOf(myValueExpression) + "&& ";
                continue;
            }
            boolean eval = this.isFeatureValuePairValid(feature, value, featureDefArt);
            myValueExpression = String.valueOf(myValueExpression) + eval + " ";
        }
        return myValueExpression;
    }

    private boolean isFeatureValuePairValid(String feature, String value, ArtifactReadable featureDefArt) {
        if (this.featureValuesAllowed.containsKey((Object)feature.toUpperCase())) {
            Collection validValues = this.featureValuesAllowed.getValues((Object)feature.toUpperCase());
            String string = value = value.equalsIgnoreCase("Default") ? this.getDefaultValue(feature, featureDefArt) : value;
            if (ApplicabilityExpression.containsIgnoreCase(validValues, value)) {
                return true;
            }
        }
        return false;
    }

    private static boolean containsIgnoreCase(Collection<String> validValues, String val) {
        for (String validValue : validValues) {
            if (!validValue.equalsIgnoreCase(val)) continue;
            return true;
        }
        return false;
    }

    private String getDefaultValue(String feature, ArtifactReadable featureDefArt) {
        FeatureDefinition[] featDataList;
        String toReturn = null;
        String json = featureDefArt.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.GeneralStringData);
        FeatureDefinition[] featureDefinitionArray = featDataList = (FeatureDefinition[])JsonUtil.readValue((String)json, FeatureDefinition[].class);
        int n = featDataList.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureDefinition featData = featureDefinitionArray[n2];
            if (featData.getName().equalsIgnoreCase(feature)) {
                toReturn = featData.getDefaultValue();
                break;
            }
            ++n2;
        }
        return toReturn;
    }
}

