/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.util.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class OverlayUtil
extends CompositeImageDescriptor {
    private final Image baseImage;
    private ImageDescriptor overlayImageDescriptor;
    private int xValue = 0;
    private int yValue = 0;
    private Collection<ImageInfo> imageInfo;

    public OverlayUtil(Image baseImage, Collection<ImageInfo> imageInfo) {
        this.baseImage = baseImage;
        this.imageInfo = imageInfo;
    }

    public OverlayUtil(Image baseImage, ImageDescriptor overlayImageDescriptor, Location location) {
        this.baseImage = baseImage;
        this.overlayImageDescriptor = overlayImageDescriptor;
        this.imageInfo = new ArrayList<ImageInfo>(2);
        this.imageInfo.add(new ImageInfo(overlayImageDescriptor, location));
    }

    public OverlayUtil(Image baseImage, ImageDescriptor overlayImageDescriptor) {
        this(baseImage, overlayImageDescriptor, 0, 0);
    }

    public OverlayUtil(Image baseImage, ImageDescriptor overlayImageDescriptor, int xValue, int yValue) {
        if (baseImage == null) {
            throw new IllegalArgumentException("baseImage can not be null");
        }
        if (overlayImageDescriptor == null) {
            throw new IllegalArgumentException("overlayImageDescriptor can not be null");
        }
        this.baseImage = baseImage;
        this.overlayImageDescriptor = overlayImageDescriptor;
        this.xValue = xValue;
        this.yValue = yValue;
    }

    public void setXY(int xValue, int yValue) {
        this.xValue = xValue;
        this.yValue = yValue;
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.baseImage.getImageData(), 0, 0);
        if (this.imageInfo == null) {
            this.drawImage(this.overlayImageDescriptor.getImageData(), this.xValue, this.yValue);
        } else {
            for (ImageInfo info : this.imageInfo) {
                if (info.location == Location.TOP_LEFT) {
                    this.drawImage(info.descriptor.getImageData(), 0, 0);
                    continue;
                }
                if (info.location == Location.BOT_LEFT) {
                    this.drawImage(info.descriptor.getImageData(), 0, 8);
                    continue;
                }
                if (info.location == Location.TOP_RIGHT) {
                    this.drawImage(info.descriptor.getImageData(), 8, 0);
                    continue;
                }
                if (info.location != Location.BOT_RIGHT) continue;
                this.drawImage(info.descriptor.getImageData(), 8, 8);
            }
        }
    }

    protected Point getSize() {
        int baseWidth = this.baseImage.getBounds().width;
        int baseHeight = this.baseImage.getBounds().height;
        Image overImg = this.overlayImageDescriptor.createImage();
        int overWidth = overImg.getBounds().width;
        int overHeight = overImg.getBounds().height;
        this.overlayImageDescriptor.destroyResource((Object)overImg);
        return new Point(baseWidth > overWidth ? baseWidth : overWidth, baseHeight > overHeight ? baseHeight : overHeight);
    }

    public static class ImageInfo {
        public ImageDescriptor descriptor;
        public Location location;

        public ImageInfo(ImageDescriptor descriptor, Location location) {
            this.descriptor = descriptor;
            this.location = location;
        }
    }

    public static enum Location {
        TOP_LEFT,
        TOP_RIGHT,
        BOT_LEFT,
        BOT_RIGHT;

    }
}

