/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.column;

import org.eclipse.nebula.widgets.xviewer.IXViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.XViewerComputedColumn;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;

public class XViewerDiffsBetweenColumnsColumn
extends XViewerComputedColumn {
    private static final String ID = "ats.computed.diffsBetweenColumns";

    public XViewerDiffsBetweenColumnsColumn() {
        this(ID);
    }

    private XViewerDiffsBetweenColumnsColumn(String id) {
        super(id, XViewerText.get("column.diffsBetweenColumns.name"), 30, XViewerAlign.Left, false, SortDataType.String, false, XViewerText.get("column.diffsBetweenColumns.description"));
    }

    @Override
    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        if (this.sourceXViewerColumn == null) {
            return String.format(XViewerText.get("error.no_source_column"), this.id);
        }
        try {
            int sourceColumnNum = this.xViewer.getCustomizeMgr().getColumnNumFromXViewerColumn(this.sourceXViewerColumn);
            String sourceColumnStr = ((IXViewerLabelProvider)this.xViewer.getLabelProvider()).getColumnText(element, sourceColumnNum);
            int nextColumnNum = sourceColumnNum + 1;
            String nextColumnStr = ((IXViewerLabelProvider)this.xViewer.getLabelProvider()).getColumnText(element, nextColumnNum);
            if (sourceColumnStr == null && nextColumnStr == null) {
                return XViewerText.get("same");
            }
            if (sourceColumnStr == null) {
                return String.valueOf(XViewerText.get("different")) + " - " + XViewerText.get("column.diffsBetweenColumns.leftNull");
            }
            if (nextColumnStr == null) {
                return String.valueOf(XViewerText.get("different")) + " - " + XViewerText.get("column.diffsBetweenColumns.rightNull");
            }
            return sourceColumnStr.equals(nextColumnStr) ? XViewerText.get("same") : String.format(String.valueOf(XViewerText.get("different")) + " [%s][%s]", sourceColumnStr, nextColumnStr);
        }
        catch (Exception ex) {
            return ex.getLocalizedMessage();
        }
    }

    @Override
    public boolean isApplicableFor(XViewerColumn xViewerColumn) {
        return true;
    }

    public String getName() {
        if (this.sourceXViewerColumn == null) {
            return XViewerText.get("column.diffsBetweenColumns.name");
        }
        return String.format(XViewerText.get("column.diffsBetweenColumns.name2"), this.sourceXViewerColumn.getName());
    }

    @Override
    public XViewerDiffsBetweenColumnsColumn copy() {
        XViewerDiffsBetweenColumnsColumn col = new XViewerDiffsBetweenColumnsColumn();
        col.setXViewer((Object)this.getXViewer());
        col.setSourceXViewerColumn(this.getSourceXViewerColumn());
        return col;
    }

    public String getId() {
        if (this.sourceXViewerColumn == null) {
            return ID;
        }
        return "ats.computed.diffsBetweenColumns(" + this.sourceXViewerColumn.getId() + ")";
    }

    @Override
    public boolean isApplicableFor(String storedId) {
        return storedId.startsWith(ID);
    }

    @Override
    public XViewerComputedColumn createFromStored(XViewerColumn storedColumn) {
        return new XViewerDiffsBetweenColumnsColumn(storedColumn.getId());
    }
}

