/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.data;

import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.define.ide.traceability.data.TraceMark;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class TraceUnit {
    private final ArtifactTypeToken traceUnitType;
    private final String name;
    private final Collection<TraceMark> traceMarks;
    private URI uriPath;

    public TraceUnit(ArtifactTypeToken traceUnitType, String name) {
        this.name = name;
        this.traceUnitType = traceUnitType;
        this.traceMarks = new HashSet<TraceMark>();
    }

    public URI getUriPath() {
        return this.uriPath;
    }

    public void setUriPath(URI uriPath) {
        this.uriPath = uriPath;
    }

    public ArtifactTypeToken getTraceUnitType() {
        return this.traceUnitType;
    }

    public String getName() {
        return this.name;
    }

    public void addAllTraceMarks(Collection<TraceMark> traceItems) {
        if (Conditions.hasValues(traceItems)) {
            this.traceMarks.addAll(traceItems);
        }
    }

    public void addTraceMark(TraceMark traceMark) {
        this.traceMarks.add(traceMark);
    }

    public Collection<TraceMark> getTraceMarks() {
        return this.traceMarks;
    }

    public Set<String> getTraceMarkTypes() {
        HashSet<String> toReturn = new HashSet<String>();
        for (TraceMark traceMark : this.traceMarks) {
            toReturn.add(traceMark.getTraceType());
        }
        return toReturn;
    }

    public Collection<TraceMark> getTraceMarksByType(String type) {
        HashSet<TraceMark> toReturn = new HashSet<TraceMark>();
        for (TraceMark traceMark : this.traceMarks) {
            if (!traceMark.getTraceType().equalsIgnoreCase(type)) continue;
            toReturn.add(traceMark);
        }
        return toReturn;
    }
}

