/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.io.CharBackedInputStream;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.framework.plugin.core.util.AIFile;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.relation.RelationManager;
import org.eclipse.osee.framework.skynet.core.utility.ViewIdUtility;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.branch.ViewApplicabilityUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.XCombo;
import org.eclipse.osee.framework.ui.skynet.widgets.XListDropViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SubsystemToLowLevelReqTraceReport
extends AbstractBlam {
    private static final String LOW_LEVEL_REQUIREMENTS = "Lower Level Requirements";
    private CharBackedInputStream charBak;
    private ISheetWriter excelWriter;
    private final HashMap<String, List<Artifact>> subsysToSubsysReqsMap;
    private final List<Artifact> lowLevelReqs;
    private final HashSet<Artifact> components;
    private ArtifactTypeToken[] lowerLevelTypes;
    private XCombo branchViewWidget;
    private XListDropViewer lowerLevel;
    private AttributeTypeId safetyAttribute = CoreAttributeTypes.IDAL;
    private static final String LEGACY_DAL = "Use Legacy DAL";
    private static final String TRACE_HANDLER_CHECKBOX = "<XWidget xwidgetType=\"XCheckBox\" displayName=\"%s\" labelAfter=\"true\" horizontalLabel=\"true\"/>";

    public String getName() {
        return "Subsystem To Low Level Req Trace Report";
    }

    public SubsystemToLowLevelReqTraceReport() {
        this.subsysToSubsysReqsMap = new HashMap();
        this.components = new HashSet();
        this.lowLevelReqs = new ArrayList<Artifact>(1000);
    }

    private void init() throws IOException {
        this.subsysToSubsysReqsMap.clear();
        this.charBak = new CharBackedInputStream();
        this.excelWriter = new ExcelXmlWriter(this.charBak.getWriter());
        this.components.clear();
        this.lowLevelReqs.clear();
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Generate Report", 100);
        this.init();
        this.lowerLevelTypes = (ArtifactTypeToken[])variableMap.getCollection(ArtifactTypeToken.class, "Low Level Requirement Type(s)").stream().toArray(ArtifactTypeToken[]::new);
        List arts = variableMap.getArtifacts(LOW_LEVEL_REQUIREMENTS);
        BranchToken branch = ((Artifact)arts.get(0)).getBranch();
        Object view = variableMap.getValue("Branch View");
        this.setViewId(view);
        Object isLegacy = variableMap.getValue(LEGACY_DAL);
        if (isLegacy.equals(true)) {
            this.safetyAttribute = CoreAttributeTypes.LegacyDal;
        }
        this.excludedArtifactIdMap = ViewIdUtility.findExcludedArtifactsByView((ArtifactId)this.viewId, (BranchId)branch);
        this.initLowLevelRequirements(arts);
        this.initAllocationComponents(variableMap.getArtifacts("Allocation Components"));
        monitor.subTask("Loading Higher Level Requirements");
        monitor.worked(1);
        ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)CoreArtifactTypes.SubsystemRequirementMsWord, (BranchId)branch);
        monitor.worked(30);
        this.orderSubsystemReqs(ArtifactQuery.getArtifactFromId((ArtifactId)CoreArtifactTokens.SubSystemRequirementsFolder, (BranchId)branch));
        this.generateLowLevelToSubsystemTrace();
        this.generateSubsystemToLowLevelReqTrace();
        this.excelWriter.endWorkbook();
        IFile iFile = OseeData.getIFile((String)("Subsystem_To_Lower_Level_Trace_" + Lib.getDateTimeString() + ".xml"));
        AIFile.writeToFile((IFile)iFile, (InputStream)this.charBak);
        Program.launch((String)iFile.getLocation().toOSString());
    }

    private void generateLowLevelToSubsystemTrace() throws IOException {
        this.excelWriter.startSheet("5-2", 11);
        this.excelWriter.writeRow(new Object[]{"5-2  Requirements Traceability to Subsystem PIDS Requirements"});
        this.excelWriter.writeRow(new Object[]{LOW_LEVEL_REQUIREMENTS, null, null, null, "Traceable Subsystem Requirement"});
        this.excelWriter.writeRow(new Object[]{"SRS Paragraph #", "SRS Paragraph Title", "Qualification Method", "SRS File", "PIDS Paragraph #", "PIDS Paragraph Title", CoreAttributeTypes.Subsystem.getName(), "Software Requirement Type", "Partition", "IDAL", "Artifact ID"});
        Object[] row = new String[11];
        for (Artifact lowLevelReq : this.lowLevelReqs) {
            row[0] = (String)lowLevelReq.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, null);
            row[1] = lowLevelReq.getName();
            boolean isRelated = false;
            row[2] = lowLevelReq.getAttributesToStringSorted((AttributeTypeId)CoreAttributeTypes.QualificationMethod);
            row[3] = (String)lowLevelReq.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Subsystem, (Object)"Unspecified");
            row[7] = lowLevelReq.getArtifactType().getName();
            row[8] = lowLevelReq.getAttributesToStringSorted((AttributeTypeId)CoreAttributeTypes.Partition);
            row[9] = (String)lowLevelReq.getSoleAttributeValue(this.safetyAttribute, (Object)"Not Applicable");
            row[10] = lowLevelReq.getIdString();
            List relatedArtifacts = lowLevelReq.getRelatedArtifacts(CoreRelationTypes.RequirementTrace_HigherLevelRequirement);
            if (!relatedArtifacts.isEmpty()) {
                ViewIdUtility.removeExcludedArtifacts(relatedArtifacts.iterator(), (Set)this.excludedArtifactIdMap);
                isRelated = true;
            }
            for (Artifact subSysReq : relatedArtifacts) {
                row[4] = (String)subSysReq.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, null);
                row[5] = subSysReq.getName();
                row[6] = (String)subSysReq.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Subsystem, (Object)"");
                this.excelWriter.writeRow(row);
            }
            if (row[0] == null || isRelated) continue;
            row[6] = null;
            row[5] = null;
            row[4] = null;
            this.excelWriter.writeRow(row);
        }
        this.excelWriter.endSheet();
    }

    private void generateSubsystemToLowLevelReqTrace() throws IOException {
        this.excelWriter.startSheet("5-3", 7);
        this.excelWriter.writeRow(new Object[]{"5-3 Traceability of SRS Requirements to Allocated Subsystem PIDS Requirements"});
        this.excelWriter.writeRow(new Object[]{null, "Subsystem Requirement", null, "Traceable Lower Level Requirements", null});
        this.excelWriter.writeRow(new Object[]{"Subsystem", "PIDS Paragraph #", "PIDS Paragraph Title", "SRS Paragraph #", "SRS Paragraph Title", "Component", "Software Requirement Type"});
        for (Map.Entry<String, List<Artifact>> entry : this.subsysToSubsysReqsMap.entrySet()) {
            List<Artifact> subsysReqs = entry.getValue();
            String[] row = new String[7];
            row[0] = entry.getKey();
            for (Artifact higherLevelReq : subsysReqs) {
                this.processSubsystemReq(row, higherLevelReq);
            }
        }
        this.excelWriter.endSheet();
    }

    private void processSubsystemReq(String[] row, Artifact higherLevelReq) throws IOException {
        boolean allocated;
        List relatedArtifacts = higherLevelReq.getRelatedArtifacts(CoreRelationTypes.RequirementTrace_LowerLevelRequirement);
        ViewIdUtility.removeExcludedArtifacts(relatedArtifacts.iterator(), (Set)this.excludedArtifactIdMap);
        boolean isTraced = !Collections.disjoint(this.lowLevelReqs, relatedArtifacts);
        List allocatedComponets = higherLevelReq.getRelatedArtifacts(CoreRelationTypes.Allocation_Component);
        boolean bl = allocated = !Collections.disjoint(this.components, allocatedComponets);
        if (isTraced || allocated) {
            row[1] = (String)higherLevelReq.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, null);
            row[2] = higherLevelReq.getName();
            row[5] = allocated ? org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)", ", (Iterable)allocatedComponets) : "Missing allocation";
            if (isTraced) {
                for (Artifact lowerLevelReq : relatedArtifacts) {
                    if (!this.lowLevelReqs.contains(lowerLevelReq)) continue;
                    row[3] = (String)lowerLevelReq.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, null);
                    row[4] = lowerLevelReq.getName();
                    row[6] = lowerLevelReq.getArtifactType().getName();
                    this.excelWriter.writeRow((Object[])row);
                }
            } else {
                row[3] = null;
                row[4] = null;
                this.excelWriter.writeRow((Object[])row);
            }
        }
    }

    private void initLowLevelRequirements(List<Artifact> artifacts) {
        RelationManager.getRelatedArtifacts(artifacts, (int)999, (DeletionFlag)DeletionFlag.INCLUDE_DELETED, (RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.DefaultHierarchical_Child});
        for (Artifact artifact : artifacts) {
            if (artifact.isOfType((ArtifactTypeId[])this.lowerLevelTypes)) {
                this.lowLevelReqs.add(artifact);
            }
            for (Artifact descendant : artifact.getDescendants()) {
                if (!descendant.isOfType((ArtifactTypeId[])this.lowerLevelTypes)) continue;
                this.lowLevelReqs.add(descendant);
            }
        }
        ViewIdUtility.removeExcludedArtifacts(this.lowLevelReqs.iterator(), (Set)this.excludedArtifactIdMap);
    }

    private void initAllocationComponents(List<Artifact> artifacts) {
        RelationManager.getRelatedArtifacts(artifacts, (int)999, (DeletionFlag)DeletionFlag.INCLUDE_DELETED, (RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.DefaultHierarchical_Child});
        for (Artifact artifact : artifacts) {
            if (!artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.Folder})) {
                this.components.add(artifact);
            }
            for (Artifact descendant : artifact.getDescendants()) {
                if (descendant.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.Folder})) continue;
                this.components.add(descendant);
            }
        }
        ViewIdUtility.removeExcludedArtifacts(this.components.iterator(), (Set)this.excludedArtifactIdMap);
    }

    private String getAssociatedSubSystem(Artifact subSysReq) {
        for (Map.Entry<String, List<Artifact>> entry : this.subsysToSubsysReqsMap.entrySet()) {
            String subSysName = entry.getKey();
            List<Artifact> subsysReqs = entry.getValue();
            if (!subsysReqs.contains(subSysReq)) continue;
            return subSysName;
        }
        return "N/A";
    }

    private void orderSubsystemReqs(Artifact subsysTopFolder) {
        for (Artifact subsysFolder : subsysTopFolder.getChildren()) {
            List subsysReqs = subsysFolder.getDescendants();
            ViewIdUtility.removeExcludedArtifacts(subsysReqs.iterator(), (Set)this.excludedArtifactIdMap);
            Iterator iterator = subsysReqs.iterator();
            while (iterator.hasNext()) {
                if (((Artifact)iterator.next()).isOfType(new ArtifactTypeId[]{CoreArtifactTypes.AbstractSubsystemRequirement})) continue;
                iterator.remove();
            }
            this.subsysToSubsysReqsMap.put(subsysFolder.getName(), subsysReqs);
        }
    }

    public String getXWidgetsXml() {
        return "<xWidgets><XWidget xwidgetType=\"XListDropViewer\" displayName=\"Lower Level Requirements\" /><XWidget xwidgetType=\"XListDropViewer\" displayName=\"Allocation Components\" /><XWidget xwidgetType=\"XArtifactTypeMultiChoiceSelect\" displayName=\"Low Level Requirement Type(s)\" multiSelect=\"true\" /><XWidget xwidgetType=\"XCombo()\" displayName=\"Branch View\" horizontalLabel=\"true\"/><XWidget xwidgetType=\"XCheckBox\" displayName=\"Use Legacy DAL\" labelAfter=\"true\" horizontalLabel=\"true\"/></xWidgets>";
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener xModListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, xModListener, isEditable);
        if (xWidget.getLabel().equals(LOW_LEVEL_REQUIREMENTS)) {
            this.lowerLevel = (XListDropViewer)xWidget;
            this.lowerLevel.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    if (SubsystemToLowLevelReqTraceReport.this.branchViewWidget != null) {
                        BranchToken branch;
                        SubsystemToLowLevelReqTraceReport.this.branchViewWidget.setEditable(true);
                        List arts = SubsystemToLowLevelReqTraceReport.this.lowerLevel.getArtifacts();
                        if (arts != null && !arts.isEmpty() && (branch = ((Artifact)arts.iterator().next()).getBranch()) != null && branch.isValid()) {
                            SubsystemToLowLevelReqTraceReport.this.branchViews = ViewApplicabilityUtil.getBranchViews((BranchId)ViewApplicabilityUtil.getParentBranch((BranchId)branch));
                            SubsystemToLowLevelReqTraceReport.this.branchViewWidget.setDataStrings(SubsystemToLowLevelReqTraceReport.this.branchViews.values());
                        }
                    }
                }
            });
        } else if (xWidget.getLabel().equals("Branch View")) {
            this.branchViewWidget = (XCombo)xWidget;
            this.branchViewWidget.setEditable(false);
        }
    }

    public Collection<String> getCategories() {
        return Arrays.asList("Define.Publish");
    }

    public String getDescriptionUsage() {
        return "The Low Level Requirement artifacts will be filtered based on the type(s) selected.  The standard is to select \"Direct Software Requirement\".";
    }

    public Collection<IUserGroupArtifactToken> getUserGroups() {
        return Collections.singleton(CoreUserGroups.Everyone);
    }
}

