/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.importing.resolvers;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.importing.RoughArtifact;
import org.eclipse.osee.framework.skynet.core.importing.resolvers.IRoughArtifactTranslator;
import org.eclipse.osee.framework.skynet.core.importing.resolvers.NewArtifactImportResolver;

public class DoorsBestFitArtifactResolver
extends NewArtifactImportResolver {
    private final boolean createNewIfNotExist;

    public DoorsBestFitArtifactResolver(IRoughArtifactTranslator translator, ArtifactTypeToken primaryArtifactType, ArtifactTypeToken secondaryArtifactType, boolean createNewIfNotExist, boolean deleteUnmatchedArtifacts) {
        super(translator, primaryArtifactType, secondaryArtifactType);
        this.createNewIfNotExist = createNewIfNotExist;
    }

    @Override
    public Artifact resolve(RoughArtifact roughArtifact, BranchToken branch, Artifact realParent, Artifact root) {
        Artifact realArtifact = null;
        if (roughArtifact.getGuid() != null) {
            realArtifact = this.findMatchByGUID(roughArtifact, root);
            if (realArtifact == null) {
                realArtifact = this.findMatchBySysSpec(roughArtifact, root);
            }
            if (realArtifact != null) {
                this.getTranslator().translate(roughArtifact, realArtifact);
            }
        } else {
            OseeLog.logf(DoorsBestFitArtifactResolver.class, (Level)Level.INFO, (String)"Doors Best Fit based resolver is comparing a null GUID. roughArtifactifact: [%s]. Attributes: [%s]", (Object[])new Object[]{roughArtifact, roughArtifact.getAttributes()});
        }
        if (realArtifact == null && this.createNewIfNotExist) {
            realArtifact = super.resolve(roughArtifact, branch, null, root);
        }
        return realArtifact;
    }

    private boolean guidsMatch(RoughArtifact roughArt, Artifact realArt) {
        String roughGuid = roughArt.getGuid();
        String realGuid = realArt.getGuid();
        return realGuid.equals(roughGuid);
    }

    private boolean legacyIdsMatch(RoughArtifact roughArt, Artifact realArt) {
        boolean allContained = true;
        String legacyIds = realArt.getSoleAttributeValueAsString((AttributeTypeToken)CoreAttributeTypes.LegacyId, "");
        if (Strings.isValid((String)legacyIds)) {
            List<String> splitIds = Arrays.asList(legacyIds.split(","));
            String roughLegacyIds = roughArt.getRoughAttribute(CoreAttributeTypes.LegacyId.getName());
            List<String> splitRoughIds = Arrays.asList(roughLegacyIds.split(","));
            for (String splitId : splitIds) {
                if (splitRoughIds.contains(splitId)) continue;
                allContained = false;
                break;
            }
        } else {
            allContained = false;
        }
        return allContained;
    }

    private Artifact findMatchByGUID(RoughArtifact roughArtifact, Artifact root) {
        List<Artifact> descendants = root.getDescendants();
        Artifact toReturn = null;
        for (Artifact artifact : descendants) {
            if (!this.guidsMatch(roughArtifact, artifact)) continue;
            toReturn = artifact;
            break;
        }
        return toReturn;
    }

    private Artifact findMatchBySysSpec(RoughArtifact roughArtifact, Artifact root) {
        List<Artifact> descendants = root.getDescendants();
        Artifact toReturn = null;
        for (Artifact artifact : descendants) {
            if (!this.legacyIdsMatch(roughArtifact, artifact)) continue;
            toReturn = artifact;
            break;
        }
        return toReturn;
    }
}

