/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.framework.core.model.Branch;
import org.eclipse.osee.framework.core.model.cache.BranchFilter;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidArtifact;
import org.eclipse.osee.framework.skynet.core.event.model.EventChangeTypeBasicGuidArtifact;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.skynet.core.relation.RelationManager;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.framework.skynet.core.utility.IdJoinQuery;
import org.eclipse.osee.framework.skynet.core.utility.JoinUtility;
import org.eclipse.osee.jdbc.JdbcStatement;

public class ChangeArtifactType {
    private final HashSet<AttributeTypeId> attributeTypes = new HashSet();
    private final HashSet<RelationTypeToken> relationTypes = new HashSet();
    private final HashMap<BranchId, SkynetTransaction> txMap = new HashMap();
    private final Set<EventBasicGuidArtifact> artifactChanges = new HashSet<EventBasicGuidArtifact>();
    private final List<Artifact> modifiedArtifacts = new ArrayList<Artifact>();
    private static final IStatus promptStatus = new Status(2, "org.eclipse.osee.framework.skynet.core", 257, "", null);
    private final Map<GammaId, ArtifactId> gammaToArtId = new HashMap<GammaId, ArtifactId>();

    public static void changeArtifactType(Collection<? extends Artifact> inputArtifacts, ArtifactTypeToken newArtifactType, boolean prompt) {
        ChangeArtifactType app = new ChangeArtifactType();
        if (inputArtifacts.isEmpty()) {
            throw new OseeArgumentException("The artifact list can not be empty", new Object[0]);
        }
        try {
            app.internalChangeArtifactType(inputArtifacts, newArtifactType, prompt);
        }
        catch (Exception ex) {
            ArtifactQuery.reloadArtifacts(app.modifiedArtifacts);
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    private void internalChangeArtifactType(Collection<? extends Artifact> inputArtifacts, ArtifactTypeToken newArtifactType, boolean prompt) {
        boolean changeOk;
        this.createAttributeRelationTransactions(inputArtifacts, newArtifactType);
        boolean bl = changeOk = !prompt;
        if (prompt) {
            changeOk = this.doesUserAcceptArtifactChange(newArtifactType);
        }
        if (!changeOk) {
            ArtifactQuery.reloadArtifacts(this.modifiedArtifacts);
            return;
        }
        for (SkynetTransaction transaction : this.txMap.values()) {
            transaction.execute();
        }
        this.changeArtifactTypeOutsideofHistory(inputArtifacts, newArtifactType);
        this.sendLocalAndRemoteEvents(this.modifiedArtifacts);
    }

    private void sendLocalAndRemoteEvents(Collection<? extends Artifact> artifacts) {
        ArtifactEvent artifactEvent = new ArtifactEvent((BranchId)artifacts.iterator().next().getBranch());
        for (EventBasicGuidArtifact guidArt : this.artifactChanges) {
            artifactEvent.addArtifact(guidArt);
        }
        OseeEventManager.kickPersistEvent(ChangeArtifactType.class, artifactEvent);
    }

    private void createAttributeRelationTransactions(Collection<? extends Artifact> inputArtifacts, ArtifactTypeToken newArtifactType) {
        IdJoinQuery artifactJoin = this.populateArtIdsInJoinIdTable(inputArtifacts);
        IdJoinQuery branchJoin = this.populateBranchIdsJoinIdTable();
        IdJoinQuery gammaJoin = this.populateGammaIdsJoinIdTable(artifactJoin);
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
                chStmt.runPreparedQuery("select branch_id, gamma_id from osee_join_id jid1, osee_join_id jid2, osee_txs txs where jid1.query_id = ? and jid2.query_id = ? and jid1.id = txs.gamma_id and jid2.id = txs.branch_id and txs.tx_current = ?", new Object[]{gammaJoin.getQueryId(), branchJoin.getQueryId(), TxCurrent.CURRENT});
                while (chStmt.next()) {
                    GammaId gammaId = GammaId.valueOf((Long)chStmt.getLong("gamma_id"));
                    BranchId branch = BranchId.valueOf((Long)chStmt.getLong("branch_id"));
                    ArtifactId artId = this.gammaToArtId.get(gammaId);
                    Artifact artifact = ArtifactQuery.checkArtifactFromId(artId, branch, DeletionFlag.EXCLUDE_DELETED);
                    if (artifact == null) continue;
                    this.deleteInvalidAttributes(artifact, newArtifactType);
                    this.deleteInvalidRelations(artifact, newArtifactType);
                    this.addTransaction(artifact, this.txMap);
                    this.artifactChanges.add(new EventChangeTypeBasicGuidArtifact((BranchId)artifact.getBranch(), (ArtifactTypeId)artifact.getArtifactType(), newArtifactType, artifact.getGuid()));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            artifactJoin.close();
            branchJoin.close();
            gammaJoin.close();
        }
    }

    private void addTransaction(Artifact artifact, HashMap<BranchId, SkynetTransaction> txMap) {
        BranchToken branch = artifact.getBranch();
        SkynetTransaction transaction = txMap.get(branch);
        if (transaction == null) {
            transaction = TransactionManager.createTransaction((BranchId)branch, "Change Artifact Type");
            txMap.put((BranchId)branch, transaction);
        }
        transaction.addArtifact(artifact);
        this.modifiedArtifacts.add(artifact);
    }

    public static void handleRemoteChangeType(EventChangeTypeBasicGuidArtifact guidArt) {
        try {
            Artifact artifact = ArtifactCache.getActive(guidArt);
            if (artifact == null) {
                return;
            }
            ArtifactCache.deCache(artifact);
            RelationManager.deCache(artifact);
            artifact.setArtifactType(guidArt.getArtifactType());
            artifact.clearEditState();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Error handling remote change type", (Throwable)ex);
        }
    }

    private void getConflictString(StringBuilder message, ArtifactTypeToken artifactType) {
        message.append("The following types are not supported on the artifact type " + artifactType.getName() + ":\n");
        message.append("\n");
        message.append("Attribute Types:\n" + this.attributeTypes + "\n");
        message.append("\n");
        message.append("Relation Types:\n" + this.relationTypes + "\n");
    }

    private void deleteInvalidAttributes(Artifact artifact, ArtifactTypeToken artifactType) {
        for (AttributeTypeId attributeTypeId : artifact.getAttributeTypes()) {
            if (artifactType.isValidAttributeType(attributeTypeId)) continue;
            artifact.deleteAttributes(attributeTypeId);
            this.attributeTypes.add(attributeTypeId);
        }
    }

    private void deleteInvalidRelations(Artifact artifact, ArtifactTypeToken artifactType) {
        for (RelationLink link : artifact.getRelationsAll(DeletionFlag.EXCLUDE_DELETED)) {
            if (link.getRelationType().getRelationSideMax(artifactType, link.getSide((ArtifactId)artifact)) != 0) continue;
            link.delete(false);
            this.relationTypes.add(link.getRelationType());
        }
    }

    private boolean doesUserAcceptArtifactChange(ArtifactTypeToken artifactType) {
        if (!this.relationTypes.isEmpty() || !this.attributeTypes.isEmpty()) {
            Object result;
            StringBuilder sb = new StringBuilder(1024);
            this.getConflictString(sb, artifactType);
            try {
                result = DebugPlugin.getDefault().getStatusHandler(promptStatus).handleStatus(promptStatus, (Object)sb.toString());
            }
            catch (CoreException ex) {
                throw OseeCoreException.wrap((Throwable)ex);
            }
            return (Boolean)result;
        }
        return true;
    }

    private void changeArtifactTypeOutsideofHistory(Collection<? extends Artifact> inputArtifacts, ArtifactTypeToken newArtifactType) {
        ArrayList<Object[]> insertData = new ArrayList<Object[]>();
        String UPDATE = "UPDATE osee_artifact SET art_type_id = ? WHERE art_id = ?";
        for (Artifact artifact : inputArtifacts) {
            insertData.add(new Object[]{newArtifactType, artifact});
        }
        ConnectionHandler.getJdbcClient().runBatchUpdate(UPDATE, insertData);
        for (Artifact artifact : this.modifiedArtifacts) {
            artifact.setArtifactType(newArtifactType);
            artifact.clearEditState();
        }
    }

    private IdJoinQuery populateArtIdsInJoinIdTable(Collection<? extends Artifact> inputArtifacts) {
        IdJoinQuery artifactJoin = JoinUtility.createIdJoinQuery();
        artifactJoin.addAndStore(inputArtifacts);
        return artifactJoin;
    }

    private IdJoinQuery populateBranchIdsJoinIdTable() {
        IdJoinQuery branchJoin = JoinUtility.createIdJoinQuery();
        BranchFilter branchFilter = new BranchFilter(BranchArchivedState.UNARCHIVED, new BranchType[0]);
        branchFilter.setNegatedBranchStates(new BranchState[]{BranchState.PURGED, BranchState.DELETED});
        branchJoin.addAndStore(BranchManager.getBranches((Predicate<Branch>)branchFilter));
        return branchJoin;
    }

    private IdJoinQuery populateGammaIdsJoinIdTable(IdJoinQuery artIds) {
        IdJoinQuery gammaJoin = JoinUtility.createIdJoinQuery();
        Consumer<JdbcStatement> consumer = stmt -> {
            ArtifactId artId = ArtifactId.valueOf((Long)stmt.getLong("art_id"));
            GammaId gammaId = GammaId.valueOf((Long)stmt.getLong("gamma_id"));
            this.gammaToArtId.put(gammaId, artId);
            gammaJoin.add((Id)gammaId);
        };
        ConnectionHandler.getJdbcClient().runQuery(consumer, "select art_id, gamma_id from osee_artifact art, osee_join_id jid where jid.query_id = ? and jid.id = art.art_id", new Object[]{artIds.getQueryId()});
        gammaJoin.store();
        return gammaJoin;
    }
}

