/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.access;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IUserGroup;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.data.UserTokens;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.access.UserGroupImpl;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.orcs.rest.model.DatastoreEndpoint;

public class UserServiceImpl
implements UserService {
    private static UserServiceImpl userService;
    private static List<IUserGroupArtifactToken> userGrps;

    public static UserService instance() {
        return UserServiceImpl.getUserService();
    }

    public static IUserGroup getOseeAdmin() {
        return UserServiceImpl.get(CoreUserGroups.OseeAdmin);
    }

    public static IUserGroup getOseeAccessAdmin() {
        return UserServiceImpl.get(CoreUserGroups.OseeAccessAdmin);
    }

    public static IUserGroup get(IUserGroupArtifactToken userGroupArtToken) {
        return UserServiceImpl.getUserService().getUserGroup(userGroupArtToken);
    }

    public IUserGroup getUserGroup(IUserGroupArtifactToken userGroup) {
        Artifact userGroupArt = null;
        if (userGroup instanceof Artifact) {
            userGroupArt = (Artifact)userGroup;
        }
        if (userGroupArt == null) {
            userGroupArt = ArtifactQuery.getArtifactFromId((ArtifactId)userGroup, (BranchId)CoreBranches.COMMON);
        }
        if (userGroupArt != null) {
            return new UserGroupImpl(userGroupArt);
        }
        throw new OseeArgumentException("parameter must be artifact", new Object[0]);
    }

    public IUserGroup getUserGroup(ArtifactToken userGroupArt) {
        return new UserGroupImpl(userGroupArt);
    }

    private static UserService getUserService() {
        if (userService == null) {
            userService = new UserServiceImpl();
        }
        return userService;
    }

    public static Collection<IUserGroupArtifactToken> getUserGrps() {
        if (userGrps == null) {
            userGrps = new ArrayList<IUserGroupArtifactToken>();
            for (Artifact userGrp : UserManager.getUser().getRelatedArtifacts(CoreRelationTypes.Users_Artifact)) {
                userGrps.add((IUserGroupArtifactToken)new UserGroupImpl(userGrp));
            }
        }
        return userGrps;
    }

    public Collection<IUserGroupArtifactToken> getMyUserGroups() {
        return UserServiceImpl.getUserGrps();
    }

    public boolean isInUserGroup(IUserGroupArtifactToken ... userGroups) {
        boolean isInGroup = false;
        Collection<IUserGroupArtifactToken> userGrps = this.getMyUserGroups();
        IUserGroupArtifactToken[] iUserGroupArtifactTokenArray = userGroups;
        int n = userGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IUserGroupArtifactToken userGroup = iUserGroupArtifactTokenArray[n2];
            if (userGrps.contains(userGroup)) {
                isInGroup = true;
                break;
            }
            ++n2;
        }
        return isInGroup;
    }

    public Collection<UserToken> getUsers(IUserGroupArtifactToken userGroup) {
        ArrayList<UserToken> users = new ArrayList<UserToken>();
        Artifact userGrpArt = ArtifactQuery.getArtifactFromToken(userGroup);
        if (userGrpArt != null && userGrpArt.isValid()) {
            List<Artifact> list = userGrpArt.getRelatedArtifacts(CoreRelationTypes.Users_User);
            for (Artifact art : list) {
                User user = (User)art;
                users.add(user);
            }
        }
        return users;
    }

    public static boolean isInUserGrp(IUserGroupArtifactToken ... userGroups) {
        return UserServiceImpl.getUserService().isInUserGroup(userGroups);
    }

    public boolean isUserMember(IUserGroupArtifactToken userGroup, Long id) {
        ArtifactToken art = ArtifactQuery.getArtifactTokenFromId((BranchId)CoreBranches.COMMON, (ArtifactId)userGroup);
        if (art.isInvalid()) {
            return false;
        }
        return this.getUserGroup(userGroup).isMember(id);
    }

    public boolean isUserMember(IUserGroupArtifactToken userGroup, ArtifactId user) {
        return this.isUserMember(userGroup, user.getId());
    }

    public UserToken getUser() {
        return UserManager.getUser();
    }

    public void setUserForCurrentThread(String loginId) {
        throw new UnsupportedOperationException();
    }

    public TransactionId createUsers(Iterable<UserToken> users, String comment) {
        DatastoreEndpoint datastoreEndpoint = ServiceUtil.getOseeClient().getDatastoreEndpoint();
        UserTokens userToks = new UserTokens();
        userToks.setAccount(SystemUser.OseeSystem);
        users.forEach(arg_0 -> ((UserTokens)userToks).addUser(arg_0));
        return datastoreEndpoint.createUsers(userToks);
    }
}

