/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.reports;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.ote.define.artifacts.TestRunOperator;
import org.eclipse.osee.ote.ui.define.internal.Activator;
import org.eclipse.osee.ote.ui.define.reports.ITestRunReport;

public class HighLevelSummary
implements ITestRunReport {
    private static final String[] HEADER = new String[]{CoreAttributeTypes.Partition.getName(), CoreAttributeTypes.Subsystem.getName(), "ScriptCount", "RunTime Issues", "Scripts with Failures", "Scripts Pass"};
    private final Map<String, CollectedData> dataMap = new HashMap<String, CollectedData>();

    @Override
    public void gatherData(IProgressMonitor monitor, TestRunOperator ... items) throws Exception {
        this.clear();
        int index = 0;
        while (index < items.length) {
            TestRunOperator operator = items[index];
            monitor.subTask(String.format("Processing [%s of%s]", index + 1, items.length));
            String partition = operator.getPartition();
            String subsystem = operator.getSubsystem();
            String key = String.format("%s:%s", partition, subsystem);
            CollectedData data = this.dataMap.get(key);
            if (data == null) {
                data = new CollectedData(partition, subsystem);
                this.dataMap.put(key, data);
            }
            try {
                this.processData(data, operator);
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
            if (monitor.isCanceled()) break;
            ++index;
        }
    }

    @Override
    public String[][] getBody() {
        int numRows = this.dataMap.size();
        ArrayList<String> keys = new ArrayList<String>(this.dataMap.keySet());
        String[][] toReturn = new String[numRows][this.getHeader().length];
        int row = 0;
        while (row < numRows) {
            String key = (String)keys.get(row);
            CollectedData collectedData = this.dataMap.get(key);
            toReturn[row] = this.addRow(collectedData);
            ++row;
        }
        return toReturn;
    }

    private String[] addRow(CollectedData data) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(data.getPartition());
        values.add(data.getSubsytem());
        values.add(Integer.toString(data.getScriptCount()));
        values.add(Integer.toString(data.getRunTimeIssues()));
        values.add(Integer.toString(data.getScriptWithFailures()));
        values.add(Integer.toString(data.getScriptPassed()));
        return values.toArray(new String[values.size()]);
    }

    @Override
    public String[] getHeader() {
        return HEADER;
    }

    @Override
    public String getTitle() {
        return "High Level Test Run Summary";
    }

    private void processData(CollectedData data, TestRunOperator operator) {
        data.incrementScriptCount();
        int failed = operator.getTestPointsFailed();
        int passed = operator.getTestPointsPassed();
        int total = operator.getTotalTestPoints();
        boolean wasAborted = operator.wasAborted();
        if (wasAborted) {
            data.incrementRunTimeIssues();
        } else if (total == 0) {
            data.incrementRunTimeIssues();
        } else if (failed > 0) {
            data.incrementScriptWithFailures();
        } else if (passed == total && failed == 0) {
            data.incrementScriptPassed();
        }
    }

    @Override
    public String getDescription() {
        return "Generates a summary report of all test runs.";
    }

    @Override
    public void clear() {
        this.dataMap.clear();
    }

    private final class CollectedData {
        private final String partition;
        private final String subsytem;
        private int scriptCount;
        private int runTimeIssues;
        private int scriptWithFailures;
        private int scriptPassed;

        public CollectedData(String partition, String subsytem) {
            this.partition = partition;
            this.subsytem = subsytem;
            this.scriptCount = 0;
            this.runTimeIssues = 0;
            this.scriptWithFailures = 0;
            this.scriptPassed = 0;
        }

        public String getPartition() {
            return this.partition;
        }

        public String getSubsytem() {
            return this.subsytem;
        }

        public int getScriptCount() {
            return this.scriptCount;
        }

        public int getRunTimeIssues() {
            return this.runTimeIssues;
        }

        public int getScriptWithFailures() {
            return this.scriptWithFailures;
        }

        public int getScriptPassed() {
            return this.scriptPassed;
        }

        public void incrementScriptCount() {
            ++this.scriptCount;
        }

        public void incrementRunTimeIssues() {
            ++this.runTimeIssues;
        }

        public void incrementScriptWithFailures() {
            ++this.scriptWithFailures;
        }

        public void incrementScriptPassed() {
            ++this.scriptPassed;
        }
    }
}

