/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.lifecycle;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.lifecycle.AbstractLifecyclePoint;
import org.eclipse.osee.framework.lifecycle.ILifecycleService;
import org.eclipse.osee.framework.lifecycle.internal.OperationPointId;

public abstract class AbstractLifecycleOperation
extends AbstractOperation {
    private final ILifecycleService service;
    private final AbstractLifecyclePoint<?> lifecyclepoint;

    public AbstractLifecycleOperation(ILifecycleService service, AbstractLifecyclePoint<?> lifecyclePoint, String operationName, String pluginId, OperationLogger logger) {
        super(operationName, pluginId, logger);
        this.service = service;
        this.lifecyclepoint = lifecyclePoint;
    }

    public AbstractLifecycleOperation(ILifecycleService service, AbstractLifecyclePoint<?> lifecyclePoint, String operationName, String pluginId) {
        super(operationName, pluginId);
        this.service = service;
        this.lifecyclepoint = lifecyclePoint;
    }

    protected final void doWork(IProgressMonitor monitor) throws Exception {
        this.doPointWork(monitor, OperationPointId.CHECK_CONDITION_ID);
        this.doPointWork(monitor, OperationPointId.PRE_CONDITION_ID);
        try {
            this.doCoreWork(monitor);
        }
        finally {
            this.doPointWork(monitor, OperationPointId.POST_CONDITION_ID);
        }
    }

    private void doPointWork(IProgressMonitor monitor, OperationPointId pointId) throws Exception {
        IStatus status = this.service.dispatch(monitor, this.lifecyclepoint, pointId.name());
        Operations.checkForErrorStatus((IStatus)status);
        AbstractLifecycleOperation.checkForCancelledStatus((IProgressMonitor)monitor);
    }

    protected abstract void doCoreWork(IProgressMonitor var1) throws Exception;
}

