/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.messaging.event.res.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.messaging.ConnectionListener;
import org.eclipse.osee.framework.messaging.ConnectionNode;
import org.eclipse.osee.framework.messaging.MessageID;
import org.eclipse.osee.framework.messaging.MessageService;
import org.eclipse.osee.framework.messaging.OseeMessagingListener;
import org.eclipse.osee.framework.messaging.OseeMessagingStatusCallback;
import org.eclipse.osee.framework.messaging.event.res.IFrameworkEventListener;
import org.eclipse.osee.framework.messaging.event.res.IOseeCoreModelEventService;
import org.eclipse.osee.framework.messaging.event.res.RemoteEvent;
import org.eclipse.osee.framework.messaging.event.res.internal.FrameworkRelayMessagingListener;
import org.eclipse.osee.framework.messaging.event.res.internal.OseeCoreModelEventServiceProxy;
import org.eclipse.osee.framework.messaging.event.res.internal.ResMessages;

public class OseeCoreModelEventServiceImpl
implements OseeMessagingStatusCallback,
IOseeCoreModelEventService {
    private final Map<IFrameworkEventListener, HashCollectionSet<ResMessages, OseeMessagingListener>> subscriptions = new ConcurrentHashMap<IFrameworkEventListener, HashCollectionSet<ResMessages, OseeMessagingListener>>();
    private final Map<ResMessages, Boolean> messages;
    private final MessageService messageService;
    private ConnectionNode connectionNode;

    public OseeCoreModelEventServiceImpl(MessageService messageService, Map<ResMessages, Boolean> messages) {
        this.messageService = messageService;
        this.messages = messages;
    }

    private synchronized ConnectionNode getConnectionNode() {
        if (this.connectionNode == null) {
            try {
                this.connectionNode = this.messageService.getDefault();
            }
            catch (OseeCoreException oseeCoreException) {
                OseeLog.log(OseeCoreModelEventServiceProxy.class, (Level)Level.SEVERE, (String)"Error initializing OseeCoreModelEventServiceProxy");
            }
        }
        return this.connectionNode;
    }

    public void success() {
    }

    public void fail(Throwable th) {
        OseeLog.log(OseeCoreModelEventServiceImpl.class, (Level)Level.SEVERE, (Throwable)th);
    }

    @Override
    public void sendRemoteEvent(RemoteEvent remoteEvent) {
        ResMessages resMessage = this.getResMessageType(remoteEvent);
        if (resMessage == null) {
            OseeLog.logf(OseeCoreModelEventServiceImpl.class, (Level)Level.INFO, (String)"ResEventManager: Unhandled remote event [%s]", (Object[])new Object[]{resMessage});
        } else if (this.getConnectionNode() == null) {
            OseeLog.logf(OseeCoreModelEventServiceImpl.class, (Level)Level.INFO, (String)"ResEventManager: Connection node was null - unable to send remote event [%s]", (Object[])new Object[]{resMessage});
        } else {
            this.getConnectionNode().send((MessageID)resMessage, (Object)remoteEvent, (OseeMessagingStatusCallback)this);
        }
    }

    private ResMessages getResMessageType(RemoteEvent remoteEvent) {
        ResMessages resMessage = null;
        if (remoteEvent != null) {
            for (ResMessages allowedMessage : this.messages.keySet()) {
                Class<? extends RemoteEvent> messageClass = allowedMessage.getSerializationClass();
                if (!messageClass.isAssignableFrom(remoteEvent.getClass())) continue;
                resMessage = allowedMessage;
                break;
            }
        }
        return resMessage;
    }

    @Override
    public void addConnectionListener(ConnectionListener connectionListener) {
        this.getConnectionNode().addConnectionListener(connectionListener);
    }

    @Override
    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.getConnectionNode().removeConnectionListener(connectionListener);
    }

    @Override
    public void addFrameworkListener(IFrameworkEventListener frameworkEventListener) {
        OseeLog.log(OseeCoreModelEventServiceImpl.class, (Level)Level.INFO, (String)"Registering Client for Remote Events");
        for (Map.Entry<ResMessages, Boolean> messageEntries : this.messages.entrySet()) {
            ResMessages resMessageID = messageEntries.getKey();
            boolean isVerbose = messageEntries.getValue();
            this.subscribe(resMessageID, resMessageID.getSerializationClass(), isVerbose, frameworkEventListener);
        }
    }

    @Override
    public void removeFrameworkListener(IFrameworkEventListener frameworkEventListener) {
        OseeLog.log(OseeCoreModelEventServiceImpl.class, (Level)Level.INFO, (String)"De-Registering Client for Remote Events");
        HashCollectionSet<ResMessages, OseeMessagingListener> listeners = this.subscriptions.get(frameworkEventListener);
        if (listeners != null) {
            for (ResMessages messageID : listeners.keySet()) {
                Collection listernerList = listeners.getValues((Object)messageID);
                if (listernerList == null) continue;
                for (OseeMessagingListener listener : listernerList) {
                    this.getConnectionNode().unsubscribe((MessageID)messageID, listener, (OseeMessagingStatusCallback)this);
                }
            }
            this.subscriptions.remove(frameworkEventListener);
        }
    }

    private <T extends RemoteEvent> void subscribe(ResMessages messageId, Class<T> clazz, boolean isVerbose, IFrameworkEventListener frameworkEventListener) {
        FrameworkRelayMessagingListener listener = new FrameworkRelayMessagingListener(clazz, frameworkEventListener, isVerbose);
        this.getConnectionNode().subscribe((MessageID)messageId, listener, (OseeMessagingStatusCallback)this);
        HashCollectionSet listeners = this.subscriptions.get(frameworkEventListener);
        if (listeners == null) {
            listeners = new HashCollectionSet(true, HashSet::new);
            this.subscriptions.put(frameworkEventListener, (HashCollectionSet<ResMessages, OseeMessagingListener>)listeners);
        }
        listeners.put((Object)messageId, listener);
    }
}

