/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.review;

import java.util.logging.Level;
import org.eclipse.osee.ats.api.review.ReviewFormalType;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.review.NewPeerReviewDialog;
import org.eclipse.osee.ats.ide.workflow.review.NewPeerToPeerReviewJob;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;

public class NewPeerToPeerReviewItem
extends XNavigateItemAction {
    public NewPeerToPeerReviewItem(XNavigateItem parent) {
        super(parent, "New Stand-alone Peer To Peer Review", (OseeImage)AtsImage.PEER_REVIEW);
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        try {
            NewPeerReviewDialog dialog = new NewPeerReviewDialog("Add New Stand-alone Peer to Peer Review", "Enter Title, Select Review Type and select Actionable Item", null, null, AtsApiService.get().getActionableItemService().getTopLevelActionableItems(Active.Active));
            if (dialog.open() == 0) {
                if (!Strings.isValid((String)dialog.getReviewTitle())) {
                    AWorkbench.popup((String)"ERROR", (String)"Must enter review title");
                    return;
                }
                ReviewFormalType reviewType = null;
                if (Strings.isValid((String)dialog.getReviewFormalType())) {
                    reviewType = ReviewFormalType.valueOf((String)dialog.getReviewFormalType());
                }
                NewPeerToPeerReviewJob job = new NewPeerToPeerReviewJob(null, dialog.getSelectedActionableItems().iterator().next(), dialog.getReviewTitle(), null, null, reviewType);
                job.setUser(true);
                job.setPriority(30);
                job.schedule();
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }
}

