/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.duplicate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IValidatingOperation;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.workflow.util.DuplicateWorkflowAsIsOperation;
import org.eclipse.osee.ats.core.workflow.util.DuplicateWorkflowAtStartStateOperation;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsUtilClient;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.AXml;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.XListDropViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DuplicateWorkflowBlam
extends AbstractBlam {
    private static final String TEAM_WORKFLOW = "Team Workflow (drop here)";
    private static final String DUPLICATE_WORKFLOW = "Duplicate Workflow - creates carbon copy with all fields and assignees intact.";
    private static final String CREATE_NEW_WORFLOW_IN_START_STATE = "Create new Workflow - creates new workflow in start state with current assignees.";
    private static final String DUPLICATE_TASKS = "Duplicate Tasks - only valid for Duplicate Workflow";
    private static final String DUPLICATE_METHOD = "Duplicate Method";
    private static final String TITLE = "New Title (blank for same title or for multiple workflows)";
    private Collection<? extends TeamWorkFlowArtifact> defaultTeamWorkflows;

    public void runOperation(final VariableMap variableMap, IProgressMonitor monitor) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                block14: {
                    try {
                        List artifacts = variableMap.getArtifacts(DuplicateWorkflowBlam.TEAM_WORKFLOW);
                        boolean duplicateTasks = variableMap.getBoolean(DuplicateWorkflowBlam.DUPLICATE_TASKS);
                        boolean createNewWorkflow = variableMap.getString(DuplicateWorkflowBlam.DUPLICATE_METHOD).equals(DuplicateWorkflowBlam.CREATE_NEW_WORFLOW_IN_START_STATE);
                        boolean duplicateWorkflow = variableMap.getString(DuplicateWorkflowBlam.DUPLICATE_METHOD).equals(DuplicateWorkflowBlam.DUPLICATE_WORKFLOW);
                        String title = variableMap.getString(DuplicateWorkflowBlam.TITLE);
                        if (artifacts.isEmpty()) {
                            AWorkbench.popup((String)"ERROR", (String)"Must drag in Team Workflow to duplicate.");
                            return;
                        }
                        if (!createNewWorkflow && !duplicateWorkflow) {
                            AWorkbench.popup((String)"ERROR", (String)"Please select \"Duplicate Method\".");
                            return;
                        }
                        if (duplicateTasks && createNewWorkflow) {
                            AWorkbench.popup((String)"ERROR", (String)"Can not create workflow as new and duplicate tasks.");
                            return;
                        }
                        Artifact artifact = (Artifact)artifacts.iterator().next();
                        if (!artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
                            AWorkbench.popup((String)"ERROR", (String)"Artifact MUST be Team Workflow");
                            return;
                        }
                        try {
                            try {
                                ArrayList<TeamWorkFlowArtifact> teamArts = new ArrayList<TeamWorkFlowArtifact>();
                                for (Artifact art : artifacts) {
                                    if (!(art instanceof TeamWorkFlowArtifact)) continue;
                                    teamArts.add((TeamWorkFlowArtifact)art);
                                }
                                if (!teamArts.isEmpty() && DuplicateWorkflowBlam.this.defaultTeamWorkflows == null) {
                                    DuplicateWorkflowBlam.this.setDefaultTeamWorkflows(teamArts);
                                }
                                if (createNewWorkflow) {
                                    DuplicateWorkflowBlam.this.handleCreateNewWorkflow(teamArts, title);
                                    break block14;
                                }
                                DuplicateWorkflowBlam.this.handleCreateDuplicate(teamArts, duplicateTasks, title);
                            }
                            catch (Exception ex) {
                                DuplicateWorkflowBlam.this.log(ex);
                                AtsUtilClient.setEmailEnabled(true);
                            }
                        }
                        finally {
                            AtsUtilClient.setEmailEnabled(true);
                        }
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                }
            }
        });
    }

    private void handleCreateNewWorkflow(Collection<TeamWorkFlowArtifact> teamArts, String title) {
        AtsUser user = AtsApiService.get().getUserService().getCurrentUser();
        LinkedList<TeamWorkFlowArtifact> teamWfs = new LinkedList<TeamWorkFlowArtifact>();
        for (TeamWorkFlowArtifact teamWorkFlowArtifact : this.getDefaultTeamWorkflows()) {
            teamWfs.add(teamWorkFlowArtifact);
        }
        DuplicateWorkflowAtStartStateOperation duplicateWorkflowAtStartStateOperation = new DuplicateWorkflowAtStartStateOperation(teamWfs, title, user, (AtsApi)AtsApiService.get());
        DuplicateWorkflowAtStartStateOperation operation = duplicateWorkflowAtStartStateOperation;
        XResultData results = this.validateAndRun((IValidatingOperation)operation);
        if (!results.isErrors()) {
            for (IAtsTeamWorkflow newTeamArt : duplicateWorkflowAtStartStateOperation.getResults().values()) {
                WorkflowEditor.edit((IAtsWorkItem)newTeamArt);
            }
        }
    }

    private XResultData validateAndRun(IValidatingOperation operation) {
        XResultData results = operation.validate();
        if (results.isErrors()) {
            XResultDataUI.report((XResultData)results, (String)this.getName());
            return results;
        }
        results = operation.run();
        if (results.isErrors()) {
            XResultDataUI.report((XResultData)results, (String)this.getName());
            return results;
        }
        return results;
    }

    private void handleCreateDuplicate(Collection<TeamWorkFlowArtifact> teamArts, boolean duplicateTasks, String title) {
        AtsUser user = AtsApiService.get().getUserService().getCurrentUser();
        LinkedList<TeamWorkFlowArtifact> teamWfs = new LinkedList<TeamWorkFlowArtifact>();
        for (TeamWorkFlowArtifact teamWorkFlowArtifact : this.getDefaultTeamWorkflows()) {
            teamWfs.add(teamWorkFlowArtifact);
        }
        DuplicateWorkflowAsIsOperation duplicateWorkflowAsIsOperation = new DuplicateWorkflowAsIsOperation(teamWfs, duplicateTasks, title, user, (AtsApi)AtsApiService.get());
        DuplicateWorkflowAsIsOperation operation = duplicateWorkflowAsIsOperation;
        XResultData results = this.validateAndRun((IValidatingOperation)operation);
        if (!results.isErrors()) {
            for (IAtsTeamWorkflow newTeamArt : duplicateWorkflowAsIsOperation.getResults().values()) {
                WorkflowEditor.edit((IAtsWorkItem)newTeamArt);
            }
        }
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener modListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, modListener, isEditable);
        if (xWidget.getLabel().equals(TEAM_WORKFLOW) && this.defaultTeamWorkflows != null) {
            XListDropViewer viewer = (XListDropViewer)xWidget;
            viewer.setInput(this.defaultTeamWorkflows);
        }
    }

    public String getXWidgetsXml() {
        return "<xWidgets><XWidget xwidgetType=\"XListDropViewer\" displayName=\"Team Workflow (drop here)\" /><XWidget xwidgetType=\"XCombo(Create new Workflow - creates new workflow in start state with current assignees.,Duplicate Workflow - creates carbon copy with all fields and assignees intact.)\" required=\"true\" displayName=\"Duplicate Method\" horizontalLabel=\"true\" /><XWidget xwidgetType=\"XCheckBox\" displayName=\"Duplicate Tasks - only valid for Duplicate Workflow\" horizontalLabel=\"true\" defaultValue=\"false\"/><XWidget xwidgetType=\"XText\" displayName=\"New Title (blank for same title or for multiple workflows)\" horizontalLabel=\"true\" defaultValue=\"" + this.getDefaultTitle() + "\"/>" + "</xWidgets>";
    }

    private String getDefaultTitle() {
        if (this.defaultTeamWorkflows != null && this.defaultTeamWorkflows.size() == 1) {
            return AXml.textToXml((String)("Copy of " + this.defaultTeamWorkflows.iterator().next().getName()));
        }
        return "";
    }

    public String getDescriptionUsage() {
        return "Duplicate team workflow(s) as a carbon copy (all fields/states/assignees will be exactly as they are) or as new workflows in start state.";
    }

    public Collection<? extends TeamWorkFlowArtifact> getDefaultTeamWorkflows() {
        return this.defaultTeamWorkflows;
    }

    public void setDefaultTeamWorkflows(Collection<? extends TeamWorkFlowArtifact> defaultTeamWorkflows) {
        this.defaultTeamWorkflows = defaultTeamWorkflows;
    }

    public String getName() {
        return "Duplicate Workflow";
    }

    public Collection<String> getCategories() {
        return Arrays.asList("ATS");
    }

    public Collection<IUserGroupArtifactToken> getUserGroups() {
        return Collections.singleton(CoreUserGroups.Everyone);
    }
}

