/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workdef.IAtsWorkDefinition;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.model.RuleDefinitionOption;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.log.IAtsLog;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogItem;
import org.eclipse.osee.ats.api.workflow.log.LogType;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractAtsArtifact;
import org.eclipse.osee.ats.ide.workflow.review.AbstractReviewArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.util.IGroupExplorerProvider;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.relation.RelationManager;

public abstract class AbstractWorkflowArtifact
extends AbstractAtsArtifact
implements IAtsWorkItem,
IGroupExplorerProvider {
    private Collection<AtsUser> transitionAssignees;
    protected AbstractWorkflowArtifact parentAwa;
    protected TeamWorkFlowArtifact parentTeamArt;
    protected IAtsAction parentAction;
    private IAtsLog atsLog;
    private TransactionId atsLogTx;
    public String implementersStr = null;

    public AbstractWorkflowArtifact(Long id, String guid, BranchToken branch, ArtifactTypeToken artifactType) {
        super(id, guid, branch, artifactType);
    }

    public List<AtsUser> getImplementers() {
        return AtsApiService.get().getImplementerService().getImplementers((IAtsObject)this);
    }

    public AbstractWorkflowArtifact getParentAWA() {
        return this.parentAwa;
    }

    public IAtsTeamWorkflow getParentTeamWorkflow() {
        return this.parentTeamArt;
    }

    public IAtsAction getParentAction() {
        Artifact actionArt = (Artifact)this.parentAction;
        if (actionArt != null) {
            return AtsApiService.get().getWorkItemService().getAction((ArtifactToken)actionArt);
        }
        return null;
    }

    public String getEditorTitle() {
        return this.getArtifactType() + ": " + this.getName();
    }

    public void clearCaches() {
        this.implementersStr = null;
        this.parentAction = null;
        this.parentAwa = null;
        this.parentTeamArt = null;
        AtsApiService.get().getStateFactory().clearStateManager((Id)this);
        this.atsLog = null;
        AtsApiService.get().getWorkDefinitionService().internalClearWorkDefinition((IAtsWorkItem)this);
    }

    public String getCurrentStateName() {
        return this.getStateMgr().getCurrentStateName();
    }

    public boolean isInState(IStateToken state) {
        return this.getStateMgr().getCurrentStateName().equals(state.getName());
    }

    public double getManHrsPerDayPreference() {
        return 8.0;
    }

    public XResultData isWfeDirty(XResultData rd) {
        try {
            HashSet<Artifact> artifacts = new HashSet<Artifact>();
            this.getSmaArtifactsOneLevel(this, artifacts);
            for (Artifact artifact : artifacts) {
                if (artifact instanceof AbstractWorkflowArtifact) {
                    AbstractWorkflowArtifact awa = (AbstractWorkflowArtifact)artifact;
                    if (awa.getStateMgr() == null) {
                        rd.errorf("StateManager can not be null for %s", new Object[]{artifact.toStringWithId()});
                    }
                    awa.getStateMgr().isDirty();
                    if (awa.getLog().isDirty()) {
                        rd.error("Log is dirty");
                    }
                }
                if (!artifact.isDirty()) continue;
                for (Attribute attribute : artifact.internalGetAttributes()) {
                    if (!attribute.isDirty()) continue;
                    rd.errorf("Dirty Attribute: " + attribute.getNameValueDescription() + "\n", new Object[0]);
                }
                String rString = RelationManager.reportHasDirtyLinks((Artifact)artifact);
                if (!Strings.isValid((String)rString)) continue;
                rd.errorf("Dirty Relation Tab: " + rString + " \n", new Object[0]);
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)("Unable to determine if artifact is dirty " + this.getAtsId()), (Throwable)ex);
            rd.errorf("Exception in isWfeDirty [%s]", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return rd;
    }

    public void save(IAtsChangeSet changes) {
        try {
            HashSet<Artifact> artifacts = new HashSet<Artifact>();
            this.getSmaArtifactsOneLevel(this, artifacts);
            for (Artifact artifact : artifacts) {
                if (!(artifact instanceof AbstractWorkflowArtifact)) continue;
                changes.add((Object)artifact);
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)("Can't save artifact " + this.getAtsId()), (Throwable)ex);
        }
    }

    public void revert() {
        try {
            HashSet<Artifact> artifacts = new HashSet<Artifact>();
            this.getSmaArtifactsOneLevel(this, artifacts);
            for (Artifact artifact : artifacts) {
                artifact.reloadAttributesAndRelations();
                if (!(artifact instanceof IAtsWorkItem)) continue;
                AtsApiService.get().getStateFactory().load((IAtsWorkItem)artifact, this.getStateMgr());
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)("Can't revert artifact " + this.getAtsId()), (Throwable)ex);
        }
    }

    public void getSmaArtifactsOneLevel(AbstractWorkflowArtifact smaArtifact, Set<Artifact> artifacts) {
        artifacts.add(smaArtifact);
    }

    @Override
    public Artifact getParentAtsArtifact() {
        return this.getParentAWA();
    }

    public int getPercentCompleteSMAStateTasks(IStateToken state) {
        if (!(this instanceof TeamWorkFlowArtifact)) {
            return 0;
        }
        return AtsApiService.get().getEarnedValueService().getPercentCompleteFromTasks((IAtsWorkItem)this, state);
    }

    public String getGroupExplorerName() {
        return String.format("[%s] %s", this.getStateMgr().getCurrentStateName(), this.getName());
    }

    public IAtsLog getLog() {
        if (this.atsLog == null || !this.getTransaction().equals(this.atsLogTx)) {
            this.atsLog = AtsApiService.get().getLogFactory().getLogLoaded((IAtsWorkItem)this, AtsApiService.get().getAttributeResolver());
            this.atsLogTx = this.getTransaction();
        }
        return this.atsLog;
    }

    public Result getUserInputNeeded() {
        return Result.FalseResult;
    }

    public IAtsWorkDefinition getWorkDefinition() {
        try {
            return AtsApiService.get().getWorkDefinitionService().getWorkDefinition((IAtsWorkItem)this);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return null;
        }
    }

    public IAtsStateDefinition getStateDefinition() {
        if (this.getStateMgr().getCurrentStateName() == null) {
            return null;
        }
        return this.getWorkDefinition().getStateByName(this.getStateMgr().getCurrentStateName());
    }

    public IAtsStateDefinition getStateDefinitionByName(String name) {
        return this.getWorkDefinition().getStateByName(name);
    }

    public boolean isAccessControlWrite() {
        return AtsApiService.get().getAccessControlService().hasArtifactPermission((ArtifactToken)this, PermissionEnum.WRITE, null).isSuccess();
    }

    public boolean teamDefHasRule(RuleDefinitionOption option) {
        TeamWorkFlowArtifact teamArt = null;
        if (this.isTeamWorkflow()) {
            teamArt = (TeamWorkFlowArtifact)this;
        }
        if (this instanceof AbstractReviewArtifact) {
            teamArt = (TeamWorkFlowArtifact)((AbstractReviewArtifact)this).getParentTeamWorkflow();
        }
        if (teamArt == null) {
            return false;
        }
        try {
            return AtsApiService.get().getTeamDefinitionService().hasRule(teamArt.getTeamDefinition(), option.name());
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return false;
        }
    }

    public Date getCreatedDate() {
        return (Date)this.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.CreatedDate, null);
    }

    public Date getCancelledDate() {
        return (Date)this.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.CancelledDate, null);
    }

    public AtsUser getCreatedBy() {
        String userId = (String)this.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.CreatedBy, null);
        if (Strings.isValid((String)userId)) {
            return AtsApiService.get().getUserService().getUserByUserId(userId);
        }
        return null;
    }

    public Date internalGetCancelledDate() {
        return (Date)this.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.CancelledDate, null);
    }

    public AtsUser getCancelledBy() {
        String userId = (String)this.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.CancelledBy, null);
        if (Strings.isValid((String)userId)) {
            return AtsApiService.get().getUserService().getUserByUserId(userId);
        }
        return null;
    }

    public String getCancelledReason() {
        String reason = (String)this.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.CancelledReason, null);
        if (!Strings.isValid((String)reason)) {
            reason = (String)this.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.CancelledReasonEnum, null);
        }
        if (!Strings.isValid((String)reason)) {
            reason = this.getLog().internalGetCancelledReason();
        }
        return reason;
    }

    public String getCancelledFromState() {
        return (String)this.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.CancelledFromState, null);
    }

    public Date getCompletedDate() {
        return (Date)this.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.CompletedDate, null);
    }

    public AtsUser getCompletedBy() {
        String userId = (String)this.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.CompletedBy, null);
        if (Strings.isValid((String)userId)) {
            return AtsApiService.get().getUserService().getUserByUserId(userId);
        }
        return null;
    }

    public IAtsLogItem getStateCompletedData(IStateToken state) {
        return this.getStateCompletedData(state.getName());
    }

    public IAtsLogItem getStateCompletedData(String stateName) {
        return this.getLog().getStateEvent(LogType.StateComplete, stateName);
    }

    public IAtsLogItem getStateCancelledData(IStateToken state) {
        return this.getStateCancelledData(state.getName());
    }

    public IAtsLogItem getStateCancelledData(String stateName) {
        return this.getLog().getStateEvent(LogType.StateCancelled, stateName);
    }

    public String getCompletedFromState() {
        String fromState = (String)this.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.CompletedFromState, null);
        if (!Strings.isValid((String)fromState)) {
            return this.getLog().internalGetCompletedFromState();
        }
        return fromState;
    }

    public void setTransitionAssignees(Collection<AtsUser> assignees) {
        if (assignees.contains(AtsCoreUsers.SYSTEM_USER) || assignees.contains(AtsCoreUsers.ANONYMOUS_USER)) {
            throw new OseeArgumentException("Can not assign workflow to OseeSystem or Anonymous", new Object[0]);
        }
        if (assignees.size() > 1 && assignees.contains(AtsCoreUsers.UNASSIGNED_USER)) {
            throw new OseeArgumentException("Can not assign to user and UnAssigned", new Object[0]);
        }
        this.transitionAssignees = assignees;
    }

    public boolean isAssigneeMe() {
        return this.getStateMgr().getAssignees().contains(AtsApiService.get().getUserService().getCurrentUser());
    }

    public Collection<AtsUser> getTransitionAssignees() {
        if (this.transitionAssignees != null) {
            if (!this.transitionAssignees.isEmpty() && this.transitionAssignees.contains(AtsCoreUsers.UNASSIGNED_USER)) {
                this.transitionAssignees.remove(AtsCoreUsers.UNASSIGNED_USER);
            }
            if (!this.transitionAssignees.isEmpty()) {
                return this.transitionAssignees;
            }
        }
        return this.getStateMgr().getAssignees();
    }

    public String getTransitionAssigneesStr() {
        return AtsObjects.toString((String)";  ", this.getTransitionAssignees());
    }

    public IAtsStateManager getStateMgr() {
        return AtsApiService.get().getStateFactory().getStateManager((IAtsWorkItem)this);
    }

    public void clearImplementersCache() {
        this.implementersStr = null;
    }

    public List<AtsUser> getAssignees() {
        return this.getStateMgr().getAssignees();
    }

    public String getAtsId() {
        String toReturn = this.getGuid();
        try {
            toReturn = this.getSoleAttributeValueAsString((AttributeTypeToken)AtsAttributeTypes.AtsId, toReturn);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.WARNING, (Throwable)ex);
        }
        return toReturn;
    }

    public void setStateMgr(IAtsStateManager stateMgr) {
        Conditions.assertNotNull((Object)stateMgr, (String)"StateManager", (Object[])new Object[0]);
        AtsApiService.get().getStateFactory().setStateMgr((IAtsWorkItem)this, stateMgr);
    }

    public Collection<WorkType> getWorkTypes() {
        HashSet<WorkType> workTypes = new HashSet<WorkType>();
        IAtsTeamWorkflow teamWf = this.getParentTeamWorkflow();
        if (teamWf != null) {
            for (IAtsActionableItem ai : AtsApiService.get().getActionableItemService().getActionableItems(teamWf.getTeamDefinition())) {
                Collection workTypeStrs = AtsApiService.get().getAttributeResolver().getAttributeValues((IAtsObject)ai, (AttributeTypeToken)AtsAttributeTypes.WorkType);
                for (String workTypeStr : workTypeStrs) {
                    try {
                        WorkType workType = WorkType.valueOfOrNone((String)workTypeStr);
                        workTypes.add(workType);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return workTypes;
    }

    public void setWorkTypes(List<WorkType> workTypes) {
        throw new UnsupportedOperationException();
    }

    public boolean isWorkType(WorkType workType) {
        return this.getWorkTypes().contains(workType);
    }

    public void setTags(List<String> tags) {
        throw new UnsupportedOperationException();
    }
}

