/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.defect;

import org.eclipse.osee.ats.api.review.ReviewDefectItem;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.skynet.widgets.XCombo;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XText;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Listener;

public class NewDefectDialog
extends EntryDialog {
    private XText text2;
    private XCombo severityCombo;
    private String entryText2 = "";
    private final String label2;
    private Listener okListener;
    private ReviewDefectItem.Severity severity;

    public NewDefectDialog() {
        super("Enter New Defect", "Enter Defect Description and Severity");
        super.setLabel("Enter Defect Description");
        super.setTextHeight(Integer.valueOf(100));
        this.label2 = "Enter Location of Defect";
    }

    protected void createOpenInEditorHyperlink(Composite parent) {
    }

    protected void createClearFixedFontWidgets(Composite headerComp) {
    }

    protected void createExtendedArea(Composite parent) {
        this.getErrorLabel().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                super.mouseUp(e);
                if (e.button == 3) {
                    NewDefectDialog.this.text.set("description " + AtsApiService.get().getRandomNum());
                    NewDefectDialog.this.severityCombo.set("Issue");
                    NewDefectDialog.this.text2.set("location");
                }
            }
        });
        this.severityCombo = new XCombo("Enter Defect Severity");
        this.severityCombo.setDataStrings(ReviewDefectItem.Severity.strValues().toArray(new String[ReviewDefectItem.Severity.strValues().size()]));
        this.severityCombo.createWidgets(this.customAreaParent, 1);
        this.severityCombo.addXModifiedListener(new XModifiedListener(){

            public void widgetModified(XWidget widget) {
                String str = NewDefectDialog.this.severityCombo.get();
                if (Strings.isValid((String)str)) {
                    NewDefectDialog.this.severity = ReviewDefectItem.Severity.valueOf((String)str);
                } else {
                    NewDefectDialog.this.severity = null;
                }
                NewDefectDialog.this.handleModified();
            }
        });
        this.text2 = new XText(this.label2);
        this.text2.setFillHorizontally(true);
        if (this.isFillVertically()) {
            this.text2.setFillVertically(true);
            this.text2.setHeight(100);
            this.text.setHeight(100);
            this.text2.setFont(this.getFont());
        }
        this.text2.set(this.entryText2);
        this.text2.createWidgets(this.customAreaParent, 1);
        this.text2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewDefectDialog.this.handleModified();
                NewDefectDialog.this.entryText2 = NewDefectDialog.this.text2.get();
            }
        });
    }

    public String getEntry2() {
        return this.entryText2;
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 0 && this.okListener != null) {
            this.okListener.handleEvent(null);
        }
    }

    public ReviewDefectItem.Severity getSeverity() {
        return this.severity;
    }

    public boolean isEntryValid() {
        if (!super.isEntryValid()) {
            return false;
        }
        if (!Strings.isValid((String)this.getEntry())) {
            this.setErrorString("Must enter Description");
            return false;
        }
        if (this.severity == null) {
            this.setErrorString("Must select Severity");
            return false;
        }
        return true;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.handleModified();
        return control;
    }

    public void setOkListener(Listener okListener) {
        this.okListener = okListener;
    }
}

