/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.AtsAttachment;
import org.eclipse.osee.ats.api.workflow.AtsAttachments;
import org.eclipse.osee.ats.ide.config.editor.AtsConfigLabelProvider;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeAttachmentsComposite;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeEditorAddSupportingFiles;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.skynet.util.StringNameComparator;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.XLabelValue;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeDialog;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public abstract class XAttachmentWidget
extends XLabelValue
implements ArtifactWidget {
    private final String configKey;
    private final HashMap<String, BranchId> nameLocationBranchMap = new HashMap();
    private static final String SELECT = "Select";
    private Hyperlink readHyperlink;
    private Hyperlink editHyperlink;
    private Hyperlink deleteHyperlink;
    private Hyperlink selectHyperlink;
    protected IAtsWorkItem workItem;
    private Composite parent;
    private WorkflowEditor editor;

    public XAttachmentWidget(String displayLabel, String configKey) {
        super(displayLabel, configKey);
        this.configKey = configKey;
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        super.createControls(parent, horizontalSpan);
        this.parent = parent;
        this.editor = WorkflowEditor.getWorkflowEditor(this.workItem);
        this.selectHyperlink = this.editor.getToolkit().createHyperlink(parent, SELECT, 0);
        this.selectHyperlink.setToolTipText("Select to add/replace attachment");
        this.addListener(parent, this.editor);
        this.refresh();
    }

    public void addListener(Composite lComp, WorkflowEditor editor) {
        try {
            this.selectHyperlink.addHyperlinkListener(new IHyperlinkListener(){

                public void linkEntered(HyperlinkEvent e) {
                }

                public void linkExited(HyperlinkEvent e) {
                }

                public void linkActivated(HyperlinkEvent e) {
                    XAttachmentWidget.this.getNameToLocationMap();
                    FilteredTreeDialog dialog = new FilteredTreeDialog("Select Attachment", "Select item to attach", (IContentProvider)new ArrayTreeContentProvider(), (IBaseLabelProvider)new AtsConfigLabelProvider(null));
                    dialog.setComparator((ViewerComparator)new StringNameComparator());
                    dialog.setInput((Object)XAttachmentWidget.this.getAllAttachments());
                    if (XAttachmentWidget.this.isAttachmentAttached()) {
                        if (!MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)"Attach Selected", (String)"There is already one attachment attached, Do you want to delete and replace with the new one?")) {
                            return;
                        }
                        XAttachmentWidget.this.deletePreviouslySelectedArtifact();
                    }
                    if (dialog.open() == 0) {
                        String selection = (String)dialog.getSelectedFirst();
                        for (Map.Entry entry : XAttachmentWidget.this.nameLocationBranchMap.entrySet()) {
                            if (!((String)entry.getKey()).contains(selection)) continue;
                            String[] nameLocation = ((String)entry.getKey()).split(";");
                            String attachmentName = nameLocation[0];
                            String location = nameLocation[1];
                            BranchId branchId = (BranchId)entry.getValue();
                            if (location.equals("osee")) {
                                try {
                                    Artifact art = ArtifactQuery.getArtifactFromTypeAndName((ArtifactTypeId)CoreArtifactTypes.GeneralDocument, (String)attachmentName, (BranchId)branchId);
                                    Artifact duplicateArt = art.duplicate(CoreBranches.COMMON);
                                    SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)CoreBranches.COMMON, (String)"Duplicate and store attachment");
                                    ((Artifact)XAttachmentWidget.this.workItem.getStoreObject()).addRelation(CoreRelationTypes.SupportingInfo_SupportingInfo, duplicateArt);
                                    duplicateArt.addAttribute((AttributeTypeId)CoreAttributeTypes.StaticId, (Object)XAttachmentWidget.this.getAttachmentStaticId());
                                    transaction.addArtifact(duplicateArt);
                                    transaction.execute();
                                }
                                catch (ArtifactDoesNotExist artifactDoesNotExist) {
                                    AWorkbench.popup((String)"Selected attachment does not exist");
                                }
                                return;
                            }
                            File file = new File(location);
                            if (!file.exists()) {
                                AWorkbench.popup((String)"Error Attaching Attachment", (String)String.format("Selected file [%s] does not exist.  Aborting.", file.getAbsolutePath()));
                                return;
                            }
                            ArrayList<File> selectedFile = new ArrayList<File>();
                            selectedFile.add(file);
                            Jobs.startJob((Job)new WfeEditorAddSupportingFiles(XAttachmentWidget.this.workItem, selectedFile, XAttachmentWidget.this.getAttachmentStaticId()), (boolean)true);
                        }
                    }
                }
            });
        }
        catch (Exception exception) {
            AWorkbench.popup((String)"Hyperlink does not exist");
        }
    }

    private Pair<Artifact, RelationLink> getSelectedAttachment() {
        AbstractWorkflowArtifact workflowArt = (AbstractWorkflowArtifact)this.workItem;
        Artifact thatArt = null;
        RelationLink relation = null;
        for (RelationLink rel : workflowArt.getRelations(CoreRelationTypes.SupportingInfo_SupportingInfo)) {
            if (!rel.getArtifactB().getTags().contains(this.getAttachmentStaticId())) continue;
            thatArt = rel.getArtifactB();
            relation = rel;
        }
        return new Pair(thatArt, relation);
    }

    private boolean isAttachmentAttached() {
        Pair<Artifact, RelationLink> artRelPair = this.getSelectedAttachment();
        return artRelPair.getFirst() != null && artRelPair.getSecond() != null;
    }

    public abstract String getAttachmentStaticId();

    protected String getFileListString() {
        return AtsApiService.get().getConfigValue(this.configKey);
    }

    public static void getUrlToFile(String urlStr, File outFile) throws IOException {
        URL url = new URL(urlStr);
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(url.openStream());
            Lib.inputStreamToFile((InputStream)inputStream, (File)outFile);
        }
        catch (Throwable throwable) {
            Lib.close(inputStream);
            throw throwable;
        }
        Lib.close((AutoCloseable)inputStream);
    }

    protected Map<String, BranchId> getNameToLocationMap() {
        String locationList = this.getFileListString();
        AtsAttachments allAttachments = (AtsAttachments)AtsApiService.get().jaxRsApi().readValue(locationList, AtsAttachments.class);
        for (AtsAttachment attachment : allAttachments.getAttachments()) {
            this.nameLocationBranchMap.put(String.valueOf(attachment.getName()) + ";" + attachment.getlocation(), attachment.getBranch());
        }
        return this.nameLocationBranchMap;
    }

    private void deletePreviouslySelectedArtifact() {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet("Delete Related Artifact");
        Pair<Artifact, RelationLink> entry = this.getSelectedAttachment();
        changes.deleteArtifact((ArtifactId)entry.getFirst());
        changes.execute();
    }

    private List<String> getAllAttachments() {
        ArrayList<String> allAttachments = new ArrayList<String>();
        for (Map.Entry<String, BranchId> entry : this.nameLocationBranchMap.entrySet()) {
            String[] nameLocation = entry.getKey().split(";");
            allAttachments.add(nameLocation[0]);
        }
        return allAttachments;
    }

    public void saveToArtifact() {
    }

    public void revert() {
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void setArtifact(Artifact artifact) {
        if (artifact instanceof IAtsWorkItem) {
            this.workItem = (IAtsWorkItem)artifact;
        }
    }

    public Artifact getArtifact() {
        return (Artifact)this.workItem.getStoreObject();
    }

    public void refresh() {
        if (Widgets.isAccessible((Widget)this.parent)) {
            Pair<Artifact, RelationLink> entry = this.getSelectedAttachment();
            Artifact attachmentArt = (Artifact)entry.getFirst();
            if (attachmentArt != null) {
                if (!Widgets.isAccessible((Widget)this.readHyperlink)) {
                    this.setValueText(attachmentArt.toString());
                    WorkflowEditor editor = WorkflowEditor.getWorkflowEditor(this.workItem);
                    this.readHyperlink = WfeAttachmentsComposite.createReadHyperlink((AbstractWorkflowArtifact)this.workItem, attachmentArt, this.parent, editor, "Read");
                    this.editHyperlink = WfeAttachmentsComposite.createEditHyperlink(attachmentArt, this.parent, editor);
                    this.deleteHyperlink = WfeAttachmentsComposite.createDeleteHyperlink((AbstractWorkflowArtifact)this.workItem, attachmentArt, (RelationLink)entry.getSecond(), this.parent, editor);
                }
            } else {
                if (Widgets.isAccessible((Widget)this.readHyperlink)) {
                    this.readHyperlink.dispose();
                    this.editHyperlink.dispose();
                    this.deleteHyperlink.dispose();
                }
                this.setValueText("");
            }
        }
    }
}

