/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.internal;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsUtilClient;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.model.event.DefaultBasicGuidArtifact;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidArtifact;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidRelation;
import org.eclipse.osee.framework.skynet.core.event.model.EventModType;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.skynet.core.utility.DbUtil;

public class AtsCacheManagerUpdateListener
implements IArtifactEventListener {
    private static List<Long> configReloadRelationTypeGuids = Arrays.asList(AtsRelationTypes.ActionableItemLead_Lead.getGuid(), AtsRelationTypes.TeamDefinitionToVersion_Version.getGuid(), AtsRelationTypes.TeamActionableItem_TeamDefinition.getGuid(), AtsRelationTypes.TeamLead_Team.getGuid(), AtsRelationTypes.ParallelVersion_Child.getGuid(), AtsRelationTypes.ParallelVersion_Parent.getGuid());
    private Boolean singleServerDeployment;
    private OrcsTokenService tokenService;

    public void setOrcsTokenService(OrcsTokenService tokenService) {
        this.tokenService = tokenService;
    }

    public List<? extends IEventFilter> getEventFilters() {
        return Arrays.asList(AtsUtilClient.getAtsBranchFilter());
    }

    public void handleArtifactEvent(ArtifactEvent artifactEvent, Sender sender) {
        boolean handledConfigReload;
        if (!DbUtil.isDbInit() && !AtsUtil.isInTest() && this.isSingleServerDeployment() && !(handledConfigReload = this.processArtifacts(artifactEvent, sender))) {
            this.processRelations(artifactEvent, handledConfigReload);
        }
    }

    private boolean isSingleServerDeployment() {
        if (this.singleServerDeployment == null) {
            this.singleServerDeployment = AtsApiService.get().isSingleServerDeployment();
        }
        return this.singleServerDeployment;
    }

    private void processRelations(ArtifactEvent artifactEvent, boolean handledConfigReload) {
        if (!handledConfigReload) {
            for (EventBasicGuidRelation guidRel : artifactEvent.getRelations()) {
                try {
                    RelationTypeToken typeByGuid = this.tokenService.getRelationType(guidRel.getRelTypeGuid());
                    if (!configReloadRelationTypeGuids.contains(typeByGuid.getId())) continue;
                    AtsApiService.get().reloadServerAndClientCaches();
                    break;
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        }
    }

    private boolean processArtifacts(ArtifactEvent artifactEvent, Sender sender) {
        boolean reload = false;
        for (EventBasicGuidArtifact guidArt : artifactEvent.getArtifacts()) {
            if (!guidArt.getArtifactType().matches(new Id[]{AtsArtifactTypes.Version, AtsArtifactTypes.TeamDefinition, AtsArtifactTypes.ActionableItem})) continue;
            reload = true;
            break;
        }
        if (reload) {
            try {
                AtsApiService.get().reloadServerAndClientCaches();
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        for (EventBasicGuidArtifact guidArt : artifactEvent.getArtifacts()) {
            try {
                if (!guidArt.is(new EventModType[]{EventModType.Added, EventModType.Modified}) || !sender.isRemote()) continue;
                this.handleCachesForAddedModified(guidArt);
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return reload;
    }

    private void handleCachesForAddedModified(EventBasicGuidArtifact guidArt) {
        Artifact artifact = ArtifactCache.getActive((DefaultBasicGuidArtifact)guidArt);
        if (artifact instanceof AbstractWorkflowArtifact) {
            AbstractWorkflowArtifact awa = (AbstractWorkflowArtifact)artifact;
            awa.clearCaches();
        }
    }
}

