/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate;

import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.core.util.RecentlyVisistedItem;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.ArtifactImageManager;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class RecentlyVisitedNavigateItem
extends XNavigateItemAction {
    private final RecentlyVisistedItem item;

    public RecentlyVisitedNavigateItem(XNavigateItem parent, RecentlyVisistedItem item) {
        super(parent, item.getIdToken().getName(), (KeyedImage)FrameworkImage.OPEN);
        ArtifactTypeToken artifactType = item.getArtifactType();
        if (artifactType != null && artifactType.isValid()) {
            this.oseeImage = ArtifactImageManager.getArtifactTypeImage((ArtifactTypeToken)artifactType);
        }
        this.item = item;
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        Artifact workItemArt = (Artifact)AtsApiService.get().getQueryService().getArtifact((ArtifactId)this.item.getIdToken(), (BranchId)AtsApiService.get().getAtsBranch(), DeletionFlag.INCLUDE_DELETED);
        if (workItemArt != null) {
            if (workItemArt.isDeleted()) {
                AWorkbench.popup((String)"Item has been deleted.");
                return;
            }
            IAtsWorkItem workItem = AtsApiService.get().getWorkItemService().getWorkItem((ArtifactToken)workItemArt);
            if (workItem == null) {
                AWorkbench.popupf((String)"Item %s can not be found.", (Object[])new Object[]{this.item.getIdToken()});
                return;
            }
            WorkflowEditor.edit(workItem);
        }
    }
}

