/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.section;

import java.util.logging.Level;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.workflow.history.XHistoryViewer;
import org.eclipse.osee.ats.ide.editor.tab.workflow.log.XLogViewer;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.render.RendererManager;
import org.eclipse.osee.framework.ui.swt.FontManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class WfeHistorySection
extends SectionPart {
    private final WorkflowEditor editor;
    private boolean sectionCreated = false;
    private XHistoryViewer xHistoryViewer;
    private XLogViewer xLogViewer;
    private Composite mainComp;

    public WfeHistorySection(WorkflowEditor editor, Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style | 2 | 0x100);
        this.editor = editor;
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        Section section = this.getSection();
        section.setText("Log / History");
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        section.addListener(26, new Listener(){

            public void handleEvent(Event e) {
                WfeHistorySection.this.createSection();
            }
        });
    }

    private synchronized void createSection() {
        if (this.sectionCreated) {
            return;
        }
        AbstractWorkflowArtifact awa = this.editor.getWorkItem();
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        this.mainComp = toolkit.createComposite((Composite)this.getSection(), 64);
        this.mainComp.setLayout((Layout)new GridLayout(1, false));
        this.mainComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Label logLabel = toolkit.createLabel(this.mainComp, "ATS Log:", 0);
        logLabel.setFont(FontManager.getCourierNew12Bold());
        this.xLogViewer = new XLogViewer(awa);
        this.xLogViewer.createWidgets(this.mainComp, 2);
        Label historyLabel = toolkit.createLabel(this.mainComp, "Detailed History (if available):", 0);
        historyLabel.setFont(FontManager.getCourierNew12Bold());
        this.xHistoryViewer = new XHistoryViewer(awa);
        this.xHistoryViewer.createWidgets(this.mainComp, 2);
        Label button = toolkit.createLabel(this.mainComp, "   ", 0);
        button.setText("    ");
        final AbstractWorkflowArtifact fSma = awa;
        button.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                try {
                    RendererManager.open((Artifact)fSma, (PresentationType)PresentationType.GENERALIZED_EDIT);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        });
        this.getSection().setClient((Control)this.mainComp);
        toolkit.paintBordersFor(this.mainComp);
        this.sectionCreated = true;
    }

    public void refresh() {
        if (this.xHistoryViewer != null) {
            this.xHistoryViewer.refresh();
        }
        if (this.xLogViewer != null) {
            this.xLogViewer.refresh();
        }
    }

    public boolean isDisposed() {
        return this.mainComp == null || this.mainComp.isDisposed();
    }
}

