/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Date;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.DeadlineManager;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsAttributeValueColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;

public class DeadlineColumn
extends XViewerAtsAttributeValueColumn {
    public static DeadlineColumn instance = new DeadlineColumn();

    public static DeadlineColumn getInstance() {
        return instance;
    }

    private DeadlineColumn() {
        super((AttributeTypeToken)AtsAttributeTypes.NeedBy, "ats.column.deadline", AtsAttributeTypes.NeedBy.getUnqualifiedName(), 75, XViewerAlign.Left, true, SortDataType.Date, true, "");
    }

    @Override
    public DeadlineColumn copy() {
        DeadlineColumn newXCol = new DeadlineColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    @Override
    public Image getColumnImage(Object element, XViewerColumn xCol, int columnIndex) {
        block4: {
            try {
                if (AtsObjects.isAtsWorkItemOrAction((Object)element)) break block4;
                return null;
            }
            catch (Exception exception) {}
        }
        if (DeadlineColumn.isDeadlineAlerting(element).isTrue()) {
            return ImageManager.getImage((KeyedImage)FrameworkImage.WARNING);
        }
        return null;
    }

    public static Result isDeadlineAlerting(Object object) {
        if (object instanceof AbstractWorkflowArtifact) {
            return DeadlineManager.isDeadlineDateAlerting((AbstractWorkflowArtifact)((Object)object));
        }
        if (Artifacts.isOfType((Object)object, (ArtifactTypeToken)AtsArtifactTypes.Action)) {
            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams(object)) {
                Result result = DeadlineColumn.isDeadlineAlerting(team);
                if (!result.isTrue()) continue;
                return result;
            }
        }
        return Result.FalseResult;
    }

    public static Date getDate(Object object) {
        TeamWorkFlowArtifact teamArt;
        if (Artifacts.isOfType((Object)object, (ArtifactTypeToken)AtsArtifactTypes.Action)) {
            return DeadlineColumn.getDate(AtsApiService.get().getWorkItemService().getFirstTeam(object));
        }
        if (Artifacts.isOfType((Object)object, (ArtifactTypeToken)AtsArtifactTypes.TeamWorkflow)) {
            return (Date)((TeamWorkFlowArtifact)((Object)object)).getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.NeedBy, null);
        }
        if (object instanceof AbstractWorkflowArtifact && (teamArt = (TeamWorkFlowArtifact)((AbstractWorkflowArtifact)((Object)object)).getParentTeamWorkflow()) != null) {
            return DeadlineColumn.getDate((Object)teamArt);
        }
        return null;
    }

    public static String getDateStr(AbstractWorkflowArtifact artifact) {
        return DateUtil.getMMDDYY((Date)DeadlineColumn.getDate((Object)artifact));
    }

    @Override
    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        String value = super.getColumnText(element, column, columnIndex);
        if (Strings.isValid((String)value)) {
            return value;
        }
        try {
            return DateUtil.getMMDDYYHHMM((Date)DeadlineColumn.getDate(element));
        }
        catch (OseeCoreException ex) {
            return LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
    }
}

