/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.xnavigate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.ui.plugin.xnavigate.INavigateItemRefresher;
import org.eclipse.osee.framework.ui.plugin.xnavigate.IXNavigateMenuItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;

public class XNavigateItem {
    private final List<XNavigateItem> children = new ArrayList<XNavigateItem>();
    private String name;
    private XNavigateItem parent;
    protected KeyedImage oseeImage;
    private List<IXNavigateMenuItem> menuItems;
    private Object data;
    private long id = 0L;
    protected INavigateItemRefresher refresher;

    public XNavigateItem(XNavigateItem parent, String name, OseeImage oseeImage) {
        this(parent, name, ImageManager.create((OseeImage)oseeImage));
    }

    public XNavigateItem(XNavigateItem parent, String name, KeyedImage oseeImage) {
        this.parent = parent;
        this.name = name;
        this.oseeImage = oseeImage;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public void addChild(XNavigateItem item) {
        this.children.add(item);
        item.setParent(this);
    }

    public void removeChild(XNavigateItem item) {
        this.children.remove(item);
        item.setParent(null);
    }

    public List<XNavigateItem> getChildren() {
        return this.children;
    }

    public String getName() {
        return this.name;
    }

    public XNavigateItem getParent() {
        return this.parent;
    }

    public String getDescription() {
        return "";
    }

    public Image getImage() {
        if (this.oseeImage != null) {
            return ImageManager.getImage((KeyedImage)this.oseeImage);
        }
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) throws Exception {
    }

    public boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    public void setParent(XNavigateItem parent) {
        this.parent = parent;
    }

    public String toString() {
        return this.getName();
    }

    public List<IXNavigateMenuItem> getMenuItems() {
        if (this.menuItems == null) {
            return Collections.emptyList();
        }
        return this.menuItems;
    }

    public void addMenuItem(IXNavigateMenuItem listener) {
        if (this.menuItems == null) {
            this.menuItems = new LinkedList<IXNavigateMenuItem>();
        }
        this.menuItems.add(listener);
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void refresh() {
    }

    public void setRefresher(INavigateItemRefresher refresher) {
        this.refresher = refresher;
    }
}

