/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.define.artifacts;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.OteAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.ote.define.TestRunField;

public class OteToAttributeMap {
    private static final SimpleDateFormat scriptStartEndDataFormat = new SimpleDateFormat("E MMM dd HH:mm:ss z yyyy");
    private static final SimpleDateFormat lastModifiedFormat = new SimpleDateFormat("MMM dd, yyyy HH:mm:ss a");
    private static OteToAttributeMap instance = null;
    private static Map<TestRunField, AttributeTypeId> outfileFieldToAttributeMap;

    private OteToAttributeMap() {
        outfileFieldToAttributeMap = new HashMap<TestRunField, AttributeTypeId>();
        outfileFieldToAttributeMap.put(TestRunField.USER_ID, (AttributeTypeId)CoreAttributeTypes.UserId);
        outfileFieldToAttributeMap.put(TestRunField.SCRIPT_REVISION, (AttributeTypeId)OteAttributeTypes.Revision);
        outfileFieldToAttributeMap.put(TestRunField.SCRIPT_MODIFIED_FLAG, (AttributeTypeId)OteAttributeTypes.ModifiedFlag);
        outfileFieldToAttributeMap.put(TestRunField.SCRIPT_LAST_AUTHOR, (AttributeTypeId)OteAttributeTypes.LastAuthor);
        outfileFieldToAttributeMap.put(TestRunField.SCRIPT_LAST_MODIFIED, (AttributeTypeId)OteAttributeTypes.LastModifiedDate);
        outfileFieldToAttributeMap.put(TestRunField.SCRIPT_URL, (AttributeTypeId)OteAttributeTypes.TestScriptUrl);
        outfileFieldToAttributeMap.put(TestRunField.SYSTEM_OS_ARCH, (AttributeTypeId)OteAttributeTypes.OsArchitecture);
        outfileFieldToAttributeMap.put(TestRunField.SYSTEM_OS_NAME, (AttributeTypeId)OteAttributeTypes.OsName);
        outfileFieldToAttributeMap.put(TestRunField.SYSTEM_OS_VERSION, (AttributeTypeId)OteAttributeTypes.OsVersion);
        outfileFieldToAttributeMap.put(TestRunField.SYSTEM_OSEE_VERSION, (AttributeTypeId)OteAttributeTypes.OseeVersion);
        outfileFieldToAttributeMap.put(TestRunField.SYSTEM_OSEE_SERVER_TITLE, (AttributeTypeId)OteAttributeTypes.OseeServerTitle);
        outfileFieldToAttributeMap.put(TestRunField.SYSTEM_OSEE_SERVER_JAR_VERSIONS, (AttributeTypeId)OteAttributeTypes.OseeServerJarVersion);
        outfileFieldToAttributeMap.put(TestRunField.PROCESSOR_ID, (AttributeTypeId)OteAttributeTypes.ProcessorId);
        outfileFieldToAttributeMap.put(TestRunField.SCRIPT_START_DATE, (AttributeTypeId)OteAttributeTypes.StartDate);
        outfileFieldToAttributeMap.put(TestRunField.SCRIPT_END_DATE, (AttributeTypeId)OteAttributeTypes.EndDate);
        outfileFieldToAttributeMap.put(TestRunField.SCRIPT_ELAPSED_TIME, (AttributeTypeId)OteAttributeTypes.ElapsedDate);
        outfileFieldToAttributeMap.put(TestRunField.TEST_POINTS_PASSED, (AttributeTypeId)OteAttributeTypes.Passed);
        outfileFieldToAttributeMap.put(TestRunField.TEST_POINTS_FAILED, (AttributeTypeId)OteAttributeTypes.Failed);
        outfileFieldToAttributeMap.put(TestRunField.TOTAL_TEST_POINTS, (AttributeTypeId)OteAttributeTypes.TotalTestPoints);
        outfileFieldToAttributeMap.put(TestRunField.TEST_ABORT_STATUS, (AttributeTypeId)OteAttributeTypes.ScriptAborted);
        outfileFieldToAttributeMap.put(TestRunField.QUALIFICATION_LEVEL, (AttributeTypeId)OteAttributeTypes.QualificationLevel);
        outfileFieldToAttributeMap.put(TestRunField.BUILD_ID, (AttributeTypeId)OteAttributeTypes.BuildId);
        outfileFieldToAttributeMap.put(TestRunField.IS_BATCH_MODE_ALLOWED, (AttributeTypeId)OteAttributeTypes.IsBatchModeAllowed);
        outfileFieldToAttributeMap.put(TestRunField.RAN_IN_BATCH_MODE, (AttributeTypeId)OteAttributeTypes.RanInBatchMode);
    }

    public static OteToAttributeMap getInstance() {
        if (instance == null) {
            instance = new OteToAttributeMap();
        }
        return instance;
    }

    public AttributeTypeId getAttributeType(String rawName) {
        TestRunField field = this.getFieldId(rawName);
        return outfileFieldToAttributeMap.get((Object)field);
    }

    private TestRunField getFieldId(String name) {
        TestRunField field = TestRunField.INVALID;
        try {
            field = TestRunField.valueOf(name);
        }
        catch (Exception exception) {
            field = TestRunField.INVALID;
        }
        return field;
    }

    public Object asTypedObject(AttributeTypeId attributeType, String value) throws Exception {
        Object toReturn = null;
        if (this.isDate(attributeType)) {
            toReturn = this.getFormat(attributeType).parse(value);
        } else if (this.isInteger(attributeType)) {
            if (!Strings.isValid((String)value)) {
                value = "0";
            }
            toReturn = new Integer(value);
        } else if (this.isBoolean(attributeType)) {
            if (!Strings.isValid((String)value)) {
                value = "false";
            }
            toReturn = new Boolean(value);
        } else {
            toReturn = value;
        }
        return toReturn;
    }

    private SimpleDateFormat getFormat(AttributeTypeId attributeType) {
        if (attributeType.equals(OteAttributeTypes.LastModifiedDate)) {
            return lastModifiedFormat;
        }
        return scriptStartEndDataFormat;
    }

    private boolean isDate(AttributeTypeId attributeType) {
        return attributeType.matches(new Id[]{OteAttributeTypes.LastModifiedDate, OteAttributeTypes.StartDate, OteAttributeTypes.EndDate});
    }

    private boolean isInteger(AttributeTypeId attributeType) {
        return attributeType.matches(new Id[]{OteAttributeTypes.TotalTestPoints, OteAttributeTypes.Passed, OteAttributeTypes.Failed});
    }

    private boolean isBoolean(AttributeTypeId attributeType) {
        return attributeType.matches(new Id[]{OteAttributeTypes.ScriptAborted, OteAttributeTypes.RanInBatchMode, OteAttributeTypes.IsBatchModeAllowed});
    }
}

