/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.plugin.core.server.task;

import java.io.IOException;
import java.io.ObjectOutputStream;
import org.eclipse.osee.framework.plugin.core.server.task.Parameter;

public abstract class Command {
    private final int commandId;

    public Command(int commandId) {
        this.commandId = commandId;
    }

    public void sendCommand(ObjectOutputStream toServer, Object ... parameters) throws IOException {
        toServer.writeInt(this.commandId);
        toServer.writeByte((byte)parameters.length);
        Object[] objectArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Object parameter = objectArray[n2];
            this.writeParameter(toServer, parameter);
            ++n2;
        }
        toServer.flush();
    }

    private void writeParameter(ObjectOutputStream toServer, Object parameter) throws IOException {
        if (parameter instanceof Boolean) {
            toServer.writeByte((byte)Parameter.BOOLEAN.ordinal());
            toServer.writeByte((Boolean)parameter != false ? 1 : 0);
        }
        if (parameter instanceof Byte) {
            toServer.writeByte((byte)Parameter.BYTE.ordinal());
            toServer.writeByte(((Byte)parameter).byteValue());
        }
        if (parameter instanceof Short) {
            toServer.writeByte((byte)Parameter.SHORT.ordinal());
            toServer.writeShort(((Short)parameter).shortValue());
        }
        if (parameter instanceof Character) {
            toServer.writeByte((byte)Parameter.CHAR.ordinal());
            toServer.writeChar(((Character)parameter).charValue());
        }
        if (parameter instanceof Integer) {
            toServer.writeByte((byte)Parameter.INT.ordinal());
            toServer.writeInt((Integer)parameter);
        }
        if (parameter instanceof Long) {
            toServer.writeByte((byte)Parameter.LONG.ordinal());
            toServer.writeLong((Long)parameter);
        }
        if (parameter instanceof Float) {
            toServer.writeByte((byte)Parameter.FLOAT.ordinal());
            toServer.writeFloat(((Float)parameter).floatValue());
        }
        if (parameter instanceof Double) {
            toServer.writeByte((byte)Parameter.DOUBLE.ordinal());
            toServer.writeDouble((Double)parameter);
        }
        if (parameter instanceof String) {
            toServer.writeByte((byte)Parameter.STRING.ordinal());
            toServer.writeUTF((String)parameter);
        }
    }

    public abstract Object invoke(Object ... var1) throws Exception;
}

