/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.sql;

import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.enums.ObjectType;
import org.eclipse.osee.framework.core.enums.SqlTable;

public class SqlAliasManager {
    private final HashMap<String, Alias> aliasCounter = new HashMap();
    private final List<AliasSet> usedAliases = new ArrayList<AliasSet>();
    private int level = 0;

    private AliasSet getAliasByLevel(int level) {
        AliasSet dataSet = null;
        if (level < this.usedAliases.size()) {
            dataSet = this.usedAliases.get(level);
        }
        return dataSet;
    }

    public boolean hasAlias(int level, SqlTable table, ObjectType objectType) {
        return !this.getAliases(level, table, objectType).isEmpty();
    }

    public List<String> getAliases(int level, SqlTable table, ObjectType objectType) {
        AliasSet dataSet = this.getAliasByLevel(level);
        List<String> toReturn = dataSet != null ? (objectType == null || ObjectType.UNKNOWN == objectType ? dataSet.getAliases(table.getPrefix()) : dataSet.getAliases(table.getPrefix(), objectType)) : Collections.emptyList();
        return toReturn;
    }

    public String getFirstAlias(int level, SqlTable table, ObjectType objectType) {
        List<String> aliases = this.getAliases(level, table, objectType);
        return (String)Iterables.getFirst(aliases, null);
    }

    public String getLastAlias(SqlTable table, ObjectType objectType) {
        List<String> aliases = this.getAliases(this.level, table, objectType);
        return (String)Iterables.getLast(aliases, null);
    }

    public String getNextAlias(String prefix, ObjectType type) {
        Alias alias = this.aliasCounter.get(prefix);
        if (alias == null) {
            alias = new Alias(prefix);
            this.aliasCounter.put(prefix, alias);
        }
        String aliasValue = alias.next();
        this.putAlias(prefix, type, aliasValue);
        return aliasValue;
    }

    public void putAlias(SqlTable table, ObjectType type, String alias) {
        String prefix = table.getPrefix();
        this.putAlias(prefix, type, alias);
    }

    private void putAlias(String key, ObjectType type, String alias) {
        AliasSet dataSet = null;
        if (this.level < this.usedAliases.size()) {
            dataSet = this.usedAliases.get(this.level);
        }
        if (dataSet == null) {
            dataSet = new AliasSet();
            this.usedAliases.add(this.level, dataSet);
        }
        dataSet.putAlias(key, type, alias);
    }

    public void nextLevel() {
        ++this.level;
    }

    public void reset() {
        this.level = 0;
        for (Alias alias : this.aliasCounter.values()) {
            alias.reset();
        }
        this.usedAliases.clear();
    }

    private final class Alias {
        private final String aliasPrefix;
        private int aliasSuffix;

        public Alias(String aliasPrefix) {
            this.aliasPrefix = aliasPrefix;
            this.reset();
        }

        public String next() {
            return String.valueOf(this.getName()) + this.aliasSuffix++;
        }

        public String getName() {
            return this.aliasPrefix;
        }

        public void reset() {
            this.aliasSuffix = 1;
        }
    }

    private static final class AliasSet {
        private final Map<String, ListMultimap<ObjectType, String>> used = new HashMap<String, ListMultimap<ObjectType, String>>();

        private AliasSet() {
        }

        public List<String> getAliases(String key, ObjectType type) {
            ListMultimap<ObjectType, String> data = this.used.get(key);
            return data != null ? data.get((Object)type) : Collections.emptyList();
        }

        public List<String> getAliases(String key) {
            Multimap data = (Multimap)this.used.get(key);
            return data != null ? Lists.newArrayList((Iterable)data.values()) : Collections.emptyList();
        }

        public void putAlias(String key, ObjectType type, String alias) {
            Object multimap = this.used.get(key);
            if (multimap == null) {
                multimap = AliasSet.newListMultimap();
                this.used.put(key, (ListMultimap<ObjectType, String>)multimap);
            }
            multimap.put((Object)type, (Object)alias);
        }

        private static <K, V> ListMultimap<K, V> newListMultimap() {
            LinkedHashMap map = Maps.newLinkedHashMap();
            return Multimaps.newListMultimap((Map)map, (Supplier)new Supplier<List<V>>(){

                public List<V> get() {
                    return Lists.newArrayList();
                }
            });
        }
    }
}

