/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfaceElementArrayApi;
import org.eclipse.osee.mim.InterfaceElementSearchEndpoint;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.types.ElementPosition;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.PlatformTypeToken;

public class InterfaceElementSearchEndpointImpl
implements InterfaceElementSearchEndpoint {
    private final BranchId branch;
    private final UserId account;
    private final InterfaceElementApi elementApi;
    private final InterfaceElementArrayApi elementArrayApi;
    private final InterfacePlatformTypeApi platformApi;

    public InterfaceElementSearchEndpointImpl(BranchId branch, UserId account, InterfaceElementApi interfaceElementApi, InterfaceElementArrayApi interfaceElementArrayApi, InterfacePlatformTypeApi interfacePlatformTypeApi) {
        this.account = account;
        this.branch = branch;
        this.elementApi = interfaceElementApi;
        this.elementArrayApi = interfaceElementArrayApi;
        this.platformApi = interfacePlatformTypeApi;
    }

    @Override
    public Collection<InterfaceStructureElementToken> getElements() {
        try {
            List elements = (List)this.elementApi.getAccessor().getAll(this.branch, InterfaceStructureElementToken.class);
            for (InterfaceStructureElementToken element : elements) {
                PlatformTypeToken platformType = this.platformApi.getAccessor().getByRelationWithoutId(this.branch, CoreRelationTypes.InterfaceElementPlatformType_Element, ArtifactId.valueOf((Long)element.getId()), PlatformTypeToken.class);
                element.setPlatformTypeId(platformType.getId());
                element.setPlatformTypeName(platformType.getName());
            }
            return elements;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    @Override
    public Collection<InterfaceStructureElementToken> getElements(String filter) {
        try {
            List elements = (List)this.elementApi.getAccessor().getAllByFilter(this.branch, filter, InterfaceStructureElementToken.class);
            for (InterfaceStructureElementToken element : elements) {
                PlatformTypeToken platformType = this.platformApi.getAccessor().getByRelationWithoutId(this.branch, CoreRelationTypes.InterfaceElementPlatformType_Element, ArtifactId.valueOf((Long)element.getId()), PlatformTypeToken.class);
                element.setPlatformTypeId(platformType.getId());
                element.setPlatformTypeName(platformType.getName());
            }
            return elements;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    @Override
    public Collection<InterfaceStructureElementToken> getElementsOfType(ArtifactId platformTypeId) {
        try {
            List elements = (List)this.elementApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceElementPlatformType_PlatformType, platformTypeId, InterfaceStructureElementToken.class);
            for (InterfaceStructureElementToken element : elements) {
                PlatformTypeToken platformType = this.platformApi.getAccessor().getByRelationWithoutId(this.branch, CoreRelationTypes.InterfaceElementPlatformType_Element, ArtifactId.valueOf((Long)element.getId()), PlatformTypeToken.class);
                element.setPlatformTypeId(platformType.getId());
                element.setPlatformTypeName(platformType.getName());
            }
            return elements;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    @Override
    public ElementPosition findElement(ArtifactId elementId) {
        return new ElementPosition();
    }
}

