/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.mim.InterfaceConnectionModificationEndpoint;
import org.eclipse.osee.mim.InterfaceConnectionViewApi;
import org.eclipse.osee.mim.InterfaceNodeViewApi;
import org.eclipse.osee.mim.types.InterfaceConnection;

public class InterfaceConnectionModificationEndpointImpl
implements InterfaceConnectionModificationEndpoint {
    private final BranchId branch;
    private final UserId account;
    private final ArtifactId nodeId;
    private final InterfaceNodeViewApi interfaceNodeApi;
    private final InterfaceConnectionViewApi interfaceConnectionApi;

    public InterfaceConnectionModificationEndpointImpl(BranchId branch, UserId account, ArtifactId nodeId, InterfaceNodeViewApi interfaceNodeApi, InterfaceConnectionViewApi interfaceConnectionViewApi) {
        this.account = account;
        this.branch = branch;
        this.interfaceNodeApi = interfaceNodeApi;
        this.interfaceConnectionApi = interfaceConnectionViewApi;
        this.nodeId = nodeId;
    }

    @Override
    public XResultData createNewConnection(InterfaceConnection ConnectionToCreate, String type) {
        XResultData createResults = this.interfaceConnectionApi.getInserter().addArtifact(ConnectionToCreate, this.account, this.branch);
        if (type.toLowerCase().equals("primary")) {
            createResults.merge(this.interfaceConnectionApi.getInserter().relateArtifact(this.nodeId, ArtifactId.valueOf((String)((String)createResults.getIds().get(0))), (RelationTypeToken)CoreRelationTypes.InterfaceConnectionPrimary_Connection, this.branch, this.account));
        } else if (type.toLowerCase().equals("secondary")) {
            createResults.merge(this.interfaceConnectionApi.getInserter().relateArtifact(this.nodeId, ArtifactId.valueOf((String)((String)createResults.getIds().get(0))), (RelationTypeToken)CoreRelationTypes.InterfaceConnectionSecondary_Connection, this.branch, this.account));
        }
        return createResults;
    }

    @Override
    public XResultData deleteConnection(ArtifactId ConnectionId) {
        try {
            if (this.interfaceConnectionApi.getAccessor().getByRelation(this.branch, this.nodeId, CoreRelationTypes.InterfaceConnectionPrimary_Connection, ConnectionId, InterfaceConnection.class).getId() > 0L) {
                return this.interfaceConnectionApi.getInserter().unrelateArtifact(this.nodeId, ConnectionId, (RelationTypeToken)CoreRelationTypes.InterfaceConnectionPrimary_Connection, this.branch, this.account);
            }
            if (this.interfaceConnectionApi.getAccessor().getByRelation(this.branch, this.nodeId, CoreRelationTypes.InterfaceConnectionSecondary_Connection, ConnectionId, InterfaceConnection.class).getId() > 0L) {
                return this.interfaceConnectionApi.getInserter().unrelateArtifact(this.nodeId, ConnectionId, (RelationTypeToken)CoreRelationTypes.InterfaceConnectionSecondary_Connection, this.branch, this.account);
            }
            XResultData results = new XResultData();
            LinkedList<String> idList = new LinkedList<String>();
            idList.add(String.valueOf(this.nodeId.getId()));
            idList.add(String.valueOf(ConnectionId.getId()));
            results.setIds(idList);
            results.error("Could not find matching Node to unrelate Connection");
            return results;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            XResultData results = new XResultData();
            LinkedList<String> idList = new LinkedList<String>();
            idList.add(String.valueOf(this.nodeId.getId()));
            idList.add(String.valueOf(ConnectionId.getId()));
            results.setIds(idList);
            results.error("Could not find matching Node to unrelate Connection");
            return results;
        }
    }

    @Override
    public XResultData relateConnection(ArtifactId connectionId, String type) {
        if (type.toLowerCase().equals("primary")) {
            return this.interfaceConnectionApi.getInserter().relateArtifact(this.nodeId, connectionId, (RelationTypeToken)CoreRelationTypes.InterfaceConnectionPrimary_Connection, this.branch, this.account);
        }
        if (type.toLowerCase().equals("secondary")) {
            return this.interfaceConnectionApi.getInserter().relateArtifact(this.nodeId, connectionId, (RelationTypeToken)CoreRelationTypes.InterfaceConnectionSecondary_Connection, this.branch, this.account);
        }
        return null;
    }
}

