/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.logging.Level;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.HasBranch;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.Identity;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.type.NamedIdSerializer;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.logging.OseeLog;

@JsonSerialize(using=NamedIdSerializer.class)
public interface ArtifactToken
extends ArtifactId,
HasBranch,
NamedId,
Identity<String> {
    public static final ArtifactToken SENTINEL = ArtifactToken.valueOf(ArtifactId.SENTINEL, BranchId.SENTINEL);

    default public String getGuid() {
        throw new UnsupportedOperationException("getGuid() is not supported");
    }

    public ArtifactTypeToken getArtifactType();

    default public boolean isTypeEqual(ArtifactTypeId artifactType) {
        return artifactType.equals(this.getArtifactType());
    }

    default public boolean isAttributeTypeValid(AttributeTypeId attributeType) {
        return this.getArtifactType().isValidAttributeType(attributeType);
    }

    default public boolean isOfType(ArtifactTypeId ... otherTypes) {
        ArtifactTypeId[] artifactTypeIdArray = otherTypes;
        int n = otherTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactTypeId otherType = artifactTypeIdArray[n2];
            if (this.getArtifactType().inheritsFrom(otherType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ArtifactToken valueOf(Id id, BranchId branch) {
        return ArtifactToken.valueOf(id.getId(), GUID.create(), null, branch, ArtifactTypeToken.SENTINEL);
    }

    public static ArtifactToken valueOf(ArtifactId id, String name) {
        return ArtifactToken.valueOf(id.getId(), GUID.create(), name, BranchId.SENTINEL, ArtifactTypeToken.SENTINEL);
    }

    public static ArtifactToken valueOf(ArtifactId id, BranchId branch) {
        if (id instanceof ArtifactToken) {
            return ArtifactToken.valueOf((ArtifactToken)id, branch);
        }
        return ArtifactToken.valueOf(id.getId(), GUID.create(), "", branch, ArtifactTypeToken.SENTINEL);
    }

    public static ArtifactToken valueOf(ArtifactToken token, BranchId branch) {
        String useGuid = null;
        try {
            useGuid = token.getGuid();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        return ArtifactToken.valueOf(token.getId(), useGuid, token.getName(), branch, token.getArtifactType());
    }

    public static ArtifactToken valueOf(long id, BranchId branch) {
        return ArtifactToken.valueOf(id, GUID.create(), "", branch, ArtifactTypeToken.SENTINEL);
    }

    public static ArtifactToken valueOf(long id, String name, BranchId branch) {
        return ArtifactToken.valueOf(id, GUID.create(), name, branch, ArtifactTypeToken.SENTINEL);
    }

    public static @NonNull ArtifactToken valueOf(long id, String name) {
        return ArtifactToken.valueOf(id, GUID.create(), name, BranchId.SENTINEL, ArtifactTypeToken.SENTINEL);
    }

    public static ArtifactToken valueOf(long id, String name, ArtifactTypeToken artifactType) {
        return ArtifactToken.valueOf(id, GUID.create(), name, BranchId.SENTINEL, artifactType);
    }

    public static ArtifactToken valueOf(long id, String name, BranchId branch, ArtifactTypeToken artifactType) {
        return ArtifactToken.valueOf(id, GUID.create(), name, branch, artifactType);
    }

    public static @NonNull ArtifactToken valueOf(long id, String guid, String name, BranchId branch, ArtifactTypeToken artifactType) {
        return new ArtifactTokenImpl(id, guid, name, branch, artifactType);
    }

    public static class ArtifactTokenImpl
    extends NamedIdBase
    implements ArtifactToken {
        private final BranchId branch;
        private final ArtifactTypeToken artifactType;
        private final String guid;

        public ArtifactTokenImpl(Long id, String guid, String name, BranchId branch, ArtifactTypeToken artifactType) {
            super(id, name);
            int idInt = Long.valueOf(id).intValue();
            if (idInt <= 0 && idInt != -1) {
                String msg = String.format("Token id (as int) must be > 0 or SENTINAL, not int [%s] for long id [%s] name [%s] and type [%s])", idInt, id, name, artifactType.getName());
                OseeLog.log(ArtifactToken.class, (Level)Level.SEVERE, (String)msg);
                throw new OseeArgumentException(msg, new Object[0]);
            }
            this.branch = branch;
            this.artifactType = artifactType;
            this.guid = guid;
        }

        public ArtifactTokenImpl(Long id, String name, BranchToken common, ArtifactTypeToken artifactType) {
            this(id, GUID.create(), name, common, artifactType);
        }

        @Override
        public ArtifactTypeToken getArtifactType() {
            return this.artifactType;
        }

        @Override
        public BranchToken getBranch() {
            return BranchToken.create(this.branch, "unknown");
        }

        @Override
        public String getGuid() {
            return this.guid;
        }

        @Override
        public Long getUuid() {
            return this.getId();
        }

        public boolean equals(Object obj) {
            boolean equal = super.equals(obj);
            if (equal && obj instanceof HasBranch) {
                return this.isOnSameBranch((HasBranch)obj);
            }
            return equal;
        }
    }
}

