/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.net.URI;
import java.util.concurrent.Callable;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.activity.api.ActivityLog;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserTokens;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.orcs.OrcsAdmin;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsMetaData;
import org.eclipse.osee.orcs.rest.internal.OrcsRestUtil;
import org.eclipse.osee.orcs.rest.model.DatastoreEndpoint;
import org.eclipse.osee.orcs.rest.model.DatastoreInfo;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public class DatastoreEndpointImpl
implements DatastoreEndpoint {
    @Context
    private UriInfo uriInfo;
    private final ActivityLog activityLog;
    private final OrcsAdmin adminOps;
    private final TransactionFactory txFactory;
    @HeaderParam(value="osee.account.id")
    private UserId accountId;

    public DatastoreEndpointImpl(OrcsApi orcsApi, ActivityLog activityLog) {
        this.activityLog = activityLog;
        this.adminOps = orcsApi.getAdminOps();
        this.txFactory = orcsApi.getTransactionFactory();
    }

    protected void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public DatastoreInfo getInfo() {
        Callable callable = this.adminOps.createFetchOrcsMetaData();
        OrcsMetaData metaData = (OrcsMetaData)OrcsRestUtil.executeCallable(callable);
        return this.asDatastoreInfo(metaData);
    }

    public TransactionId initialize(String typeModel) {
        return this.adminOps.createDatastoreAndSystemBranches(typeModel);
    }

    public void synonyms() {
        this.activityLog.setEnabled(false);
        this.adminOps.createSynonymsAndGrants();
        this.activityLog.setEnabled(true);
    }

    public Response migrate() {
        this.activityLog.setEnabled(false);
        Callable callable = this.adminOps.migrateDatastore();
        OrcsMetaData metaData = (OrcsMetaData)OrcsRestUtil.executeCallable(callable);
        URI location = this.getDatastoreLocation(this.uriInfo);
        return Response.created((URI)location).entity((Object)this.asDatastoreInfo(metaData)).build();
    }

    private URI getDatastoreLocation(UriInfo uriInfo) {
        return uriInfo.getRequestUriBuilder().path("../").path("info").build(new Object[0]);
    }

    private DatastoreInfo asDatastoreInfo(OrcsMetaData metaData) {
        DatastoreInfo info = new DatastoreInfo();
        info.setProperties(metaData.getProperties());
        return info;
    }

    public void createDemoBranches() {
        this.adminOps.createDemoBranches();
    }

    public TransactionId createUsers(UserTokens users) {
        TransactionBuilder tx = this.txFactory.createTransaction((BranchId)CoreBranches.COMMON, (UserId)users.getAccount(), "DatastoreEndpointImpl.createUsers()");
        this.adminOps.createUsers(tx, (Iterable)users.getUsers());
        return tx.commit();
    }

    public void updateBootstrapUser() {
        this.adminOps.updateBootstrapUser(this.accountId);
    }
}

